/*
 * STM32F4xx USB Device example programs
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    January    4th, 2020
 *      Revised:    January    6th, 2020
 */


/*
    You can select several examples as followings.
    0.  0_USB_Serial
        Send & Receive data strings via USB port to Host PC
    1.  1_USB_Storage_RW_microSD
        Access microSD drive via USB port from Host PC
    2.  2_USB_Mouse
        Mouse control for Host PC
    3.  3_USB_Keyboard
        Keyboard control for Host PC
 */
#define EXAMPLE_NUMBER      2   // select 0 or 3

//----------------- You don't need any modification ----------------------------
#if EXAMPLE_NUMBER == 0
    #define EXAMPLE_0_SERIAL
    #ifdef EXAMPLE_0_SERIAL
        #include "0_USB_Serial/main.cpp"
        #warning "Select 0_USB_Serial"
    #endif
#elif EXAMPLE_NUMBER == 1
    #define EXAMPLE_1_MSD
    #ifdef EXAMPLE_1_MSD
        #include "1_USB_Storage_RW_microSD/main.cpp"
        #warning "Select 1_USB_Storage_RW_microSD"
    #endif
#elif EXAMPLE_NUMBER == 2
    #define EXAMPLE_2_MOUSE
    #ifdef EXAMPLE_2_MOUSE
        #include "2_USB_Mouse/main.cpp"
        #warning "Select 2_USB_Mouse"
    #endif
#elif EXAMPLE_NUMBER == 3
    #define EXAMPLE_3_KEYBOARD
    #ifdef EXAMPLE_3_KEYBOARD
        #include "3_USB_Keyboard/main.cpp"
        #warning "Select 3_USB_Keyboard"
    #endif
#else
    #error " Please set 0 to 3 number for EXAMPLE_NUMBER!!"
#endif
