/*
 * mbed library program
 *  S11059 I2C interface-compatible color sensor by Hamamatsu Photonics K.K.
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Started:    December   1st, 2018
 *      Revised:    December   2nd, 2018
 */

#include "mbed.h"
#include "s11059.h"

S11059::S11059 (PinName p_sda, PinName p_scl):
    _i2c_p(new I2C(p_sda, p_scl)), _i2c(*_i2c_p)
{
    chip_addr = S11059_ADDR;
    initialize ();
}

S11059::S11059 (I2C& p_i2c):
    _i2c(p_i2c)
{
    chip_addr = S11059_ADDR;
    initialize ();
}
/////////////// Get data //////////////////////////////////
void S11059::get_data(S11059_Data_TypeDef *data)
{
    dt[0] = 0;
    dt[1] = 0x09;   // wake-up ADC, Gain x10, t_base=1.4ms
    _i2c.write(chip_addr, dt, 2, false);
    dt[0] = 0x03;
    _i2c.write(chip_addr, dt, 1, true);
    _i2c.read(chip_addr, dt, 8, false);
    data->red      = dt[0] << 8 | dt[1];
    data->green    = dt[2] << 8 | dt[3];
    data->blue     = dt[4] << 8 | dt[5];
    data->infrared = dt[6] << 8 | dt[7];
}

/////////////// Get  data (use Illuminance unit) //////////
float S11059::lux(void)
{
    return 0.0f;
}

/////////////// Reset sensor chip /////////////////////////
void S11059::reset_chip(void)
{
    ;
}

/////////////// Set Gain x1 ///////////////////////////////
void S11059::set_gain_one(void)
{
    ;
}

/////////////// Set Gain x10 //////////////////////////////
void S11059::set_gain_ten(void)
{
    ;
}

/////////////// Set fixed period time mode ////////////////
void S11059::set_fixed_mode(void)
{
    ;
}

/////////////// Set manual mode ///////////////////////////
void S11059::set_manual_mode(uint16_t num)
{
    ;
}

/////////////// Initialize ////////////////////////////////
void S11059::initialize (void)
{
    _i2c.frequency(400000);
    dt[0] = 0;
    dt[1] = 0x89;   // reset ADC, wake-up sleep mode
    _i2c.write(chip_addr, dt, 2, true);
    dt[0] = 0;
    dt[1] = 0x09;   // wake-up ADC, Gain x10, t_base=1.4ms
    _i2c.write(chip_addr, dt, 2, true);
}

/////////////// I2C Freq. /////////////////////////////////
void S11059::frequency(int hz)
{
    _i2c.frequency(hz);
}

/////////////// Read/Write specific register //////////////
uint8_t S11059::read_reg(uint8_t addr)
{
    dt[0] = addr;
    _i2c.write(chip_addr, dt, 1, true);
    _i2c.read(chip_addr, dt, 1, false);
    return (uint8_t)dt[0];
}

uint8_t S11059::write_reg(uint8_t addr, uint8_t data)
{
    uint8_t d;

    dt[0] = addr;
    dt[1] = data;
    _i2c.write(chip_addr, dt, 2, false);
    d = dt[0];
    return d;
}
