/*
 * mbed Library program / Ring Buffer
 *  CAUTION!!
 *  This is very special ring buffer which save newest data and remember
 *   some amount of old data. 
 *  If write newest data into the buffer, lose oldest data.
 *  Don't use this library as normal type of a FIFO ring buffer!!
 *
 * Copyright (c) 2016 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    September 18th, 2016
 *      Revised:    November   8th, 2016
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _RINGBUFF_H
#define _RINGBUFF_H

#define BUFFER_SIZE 4096

template <typename T>
class RingBuff
{

private:
    const int16_t buffer_size;
    int16_t head;
    int16_t head_temp;
    int16_t tail;
    int16_t tail_temp;
    T *    buff;

public:
    RingBuff(const int16_t size=BUFFER_SIZE);
    ~RingBuff();

    void        ring_put_dt (T dt);
    T           ring_get_newest_dt (void);
    T           ring_get_pointed_dt (int16_t offset);
    int16_t     ring_is_buf_full (void);
    int16_t     ring_get_buf_size (void);
    void        ring_clear_buf (void);
    int16_t     ring_is_buf_empty (void);
    void        debug_print_all_buffer(void);

};

#endif /* _RINGBUFF_H */
