/*
 * mbed Application program
 *
 *  Copyright (c) 2010-2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  March     27th, 2010
 *      Revised:  November   1st, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//#define USE_TEXT_LCD

//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"
#ifdef USE_TEXT_LCD
#include "TextLCD.h"
#endif
#include "CheckRTC.h"

//  Object ----------------------------------------------------------------------------------------
Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1);                                // Assign LED1 output port
#ifdef USE_TEXT_LCD
TextLCD lcd(p22, p21, p8, p7, p6, p5,TextLCD::LCD40x2);  // rs, e, d4-d7
#endif

//  RAM -------------------------------------------------------------------------------------------

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
void msg_hlp (void);
void chk_and_set_time(char *ptr);
void put_rn (void);
void put_r (void);
int xatoi (char **str, int32_t *res);
void get_line (char *buff, int len);

//  Definition ------------------------------------------------------------------------------------
#define BAUD(x)                 pc.baud(x)
#define GETC(x)                 pc.getc(x)
#define PUTC(x)                 pc.putc(x)
#define PRINTF(...)             pc.printf(__VA_ARGS__)
#define READABLE(x)             pc.readable(x)

#ifdef USE_TEXT_LCD
#define L_CLS(x)                lcd.cls(x) 
#define L_LOC(x,y)              lcd.locate(0, 0);
#define L_PRINTF(...)           lcd.printf(__VA_ARGS__)
#else
#define L_CLS(x)                {;} 
#define L_LOC(x,y)              {;}
#define L_PRINTF(...)           {;}
#endif

#define STYLE1
//#define STYLE2
//#define STYLE_COM

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
//  Help Massage
void msg_hlp (void)
{
    PRINTF("t - Check and set RTC");
    put_rn();
    PRINTF("/ - Show time every second (Esc -> hit any key)");
    put_rn();
    PRINTF("? - Help");
    put_rn();
}

int main()
{
    char *ptr;
    char linebuf[64];
    char buf[40];
    time_t seconds;

    CheckRTC();
    L_CLS();
    L_LOC(0, 0);
    L_LOC(0, 0);   // 1st line top
    //          1234567890123456789012345678901234567890
    L_PRINTF("  Waiting for time adjustment via com ");
    put_rn();
    seconds = time(NULL);
    PRINTF("Current time is");
    put_rn();
#ifdef STYLE_COM
    PRINTF("Time: %s", ctime(&seconds));
#else
    strftime(buf,40, "%I:%M:%S %p (%Y/%m/%d)", localtime(&seconds));
    PRINTF("Time: %s", buf);
#endif
    put_rn();
    PRINTF("Is it correct time?");
    put_rn();
    PRINTF("YES -> please enter '/'");
    put_rn();
    PRINTF("NO -> please enter t yy mm dd hh mm ss <ret>");
    put_rn();
    PRINTF("e.g. >t 14 11 1 8 5 15<ret>");
    put_rn();
    for (;;) {
        put_r();
        PUTC('>');
        ptr = linebuf;
        get_line(ptr, sizeof(linebuf));
        switch (*ptr++) {
                //---------------------------------------------------------------------------------
                //  check and set RTC
                //---------------------------------------------------------------------------------
            case 't' :
                put_r();
                chk_and_set_time(ptr);
                break;
                //---------------------------------------------------------------------------------
                //  check and set RTC
                //---------------------------------------------------------------------------------
            case '/' :
                put_r();
                PRINTF("Current Time -> Plese see LCD also");
                put_rn();
                while (1) {
                    if (READABLE()) {
                        break;
                    }
                    while ( seconds == time(NULL)) ;
                    seconds = time(NULL);
                    myled1 = !myled1;
                    L_CLS();
                    L_LOC(0, 0);   // 1st line top
                    L_PRINTF("It is %d sec since Jan.1,1970\n", seconds);
                    L_LOC(0, 1);   // 2nd line top
#ifdef STYLE1
                    //                  27 Mar 2010 13:24:00
                    strftime(buf,40, "%x %X ", localtime(&seconds));
#endif
#ifdef STYLE2
                    //                 13:24:00 PM (2010/03/27)
                    strftime(buf,40, "%I:%M:%S %p (%Y/%m/%d)", localtime(&seconds));
#endif
                    L_PRINTF("Time = %s", buf);
#ifdef STYLE_COM
                    PRINTF("Time: %s", ctime(&seconds));
#else
                    PRINTF("Time: %s", buf);
#endif
                    put_rn();
                }
                break;
                //---------------------------------------------------------------------------------
                //  check and set RTC
                //---------------------------------------------------------------------------------
            case '?' :
            default :
                put_r();
                msg_hlp();
                break;
        }
    }
}

//  Put \r\n
void put_rn (void)
{
    PUTC('\r');
    PUTC('\n');
}

//  Put \r
void put_r (void)
{
    PUTC('\r');
}

//  Change string -> number
int xatoi (char **str, int32_t *res)
{
    unsigned long val;
    unsigned char c, radix, s = 0;

    while ((c = **str) == ' ') {
        (*str)++;
    }
    if (c == '-') {
        s = 1;
        c = *(++(*str));
    }
    if (c == '0') {
        c = *(++(*str));
        if (c <= ' ') {
            *res = 0;
            return 1;
        }
        if (c == 'x') {
            radix = 16;
            c = *(++(*str));
        } else {
            if (c == 'b') {
                radix = 2;
                c = *(++(*str));
            } else {
                if ((c >= '0')&&(c <= '9')) {
                    radix = 8;
                }   else {
                    return 0;
                }
            }
        }
    } else {
        if ((c < '1')||(c > '9')) {
            return 0;
        }
        radix = 10;
    }
    val = 0;
    while (c > ' ') {
        if (c >= 'a') {
            c -= 0x20;
        }
        c -= '0';
        if (c >= 17) {
            c -= 7;
            if (c <= 9) {
                return 0;
            }
        }
        if (c >= radix) {
            return 0;
        }
        val = val * radix + c;
        c = *(++(*str));
    }
    if (s) {
        val = -val;
    }
    *res = val;
    return 1;
}

//  Get key input data
void get_line (char *buff, int len)
{
    char c;
    int idx = 0;

    for (;;) {
        c = GETC();
        if (c == '\r') {
            buff[idx++] = c;
            break;
        }
        if ((c == '\b') && idx) {
            idx--;
            PUTC(c);
            PUTC(' ');
            PUTC(c);
        }
        if (((uint8_t)c >= ' ') && (idx < len - 1)) {
            buff[idx++] = c;
            PUTC(c);
        }
    }
    buff[idx] = 0;
    PUTC('\n');
}

// RTC related subroutines
void chk_and_set_time(char *ptr)
{
    int32_t p1;
    struct tm t;
    time_t seconds;
    char buf[40];

    if (xatoi(&ptr, &p1)) {
        t.tm_year       = (uint8_t)p1 + 100;
        PRINTF("Year:%d ",p1);
        xatoi( &ptr, &p1 );
        t.tm_mon        = (uint8_t)p1 - 1;
        PRINTF("Month:%d ",p1);
        xatoi( &ptr, &p1 );
        t.tm_mday       = (uint8_t)p1;
        PRINTF("Day:%d ",p1);
        xatoi( &ptr, &p1 );
        t.tm_hour       = (uint8_t)p1;
        PRINTF("Hour:%d ",p1);
        xatoi( &ptr, &p1 );
        t.tm_min        = (uint8_t)p1;
        PRINTF("Min:%d ",p1);
        xatoi( &ptr, &p1 );
        t.tm_sec        = (uint8_t)p1;
        PRINTF("Sec: %d",p1);
        put_rn();
        seconds = mktime(&t);
        set_time(seconds);
    }
    seconds = time(NULL);
    strftime(buf, 40, "%B %d,'%y, %H:%M:%S", localtime(&seconds));
    PRINTF("Time: %s", buf);
    put_rn();
}
