//
// RTC Test Program
//          Kenji Arai / JH1PJL
//          March 27th,2010  Started
//          March 27th,2010  
//
#include "mbed.h"
#include "TextLCD.h"

#define TIME_KEEP_AS_IS
//#define STYLE1
#define STYLE2

DigitalOut myled1(LED1);                                // Assign LED1 output port
TextLCD lcd(p22, p28, p27, p26, p25, p24, p23, 40, 2);  // rs,rw,e,d0,d1,d2,d3,40char's x 2 lines

int main() {
    char buf[40];
    time_t seconds;

#ifndef TIME_KEEP_AS_IS
    // setup time structure for 27 March 2010 13:24:00
    struct tm t;
    t.tm_sec = 00;    // 0-59
    t.tm_min = 24;    // 0-59
    t.tm_hour = 13;   // 0-23
    t.tm_mday = 27;   // 1-31
    t.tm_mon = 3;     // 0-11
    t.tm_year = 110;  // year since 1900
    seconds = mktime(&t);
    set_time(seconds);
#endif
    lcd.cls();
    lcd.locate(0, 0);
    lcd.locate(0, 0);   // 1st line top    
    lcd.printf("since Jan.1,1970 = %d\n", seconds);
    wait(2.0);
    // If you have implemented the "Windows USB Serial Port Driver", you can use follows.
    // http://mbed.org/projects/handbook/wiki/WindowsSerialConfiguration
    printf("\r\n  Start RTC Test Program\r\n ");
#ifdef TIME_KEEP_AS_IS
    printf("Defined TIME_KEEP_AS_IS\r\n");
#else
    printf("Not define TIME_KEEP_AS_IS\r\n");
#endif
    for(;;){
        myled1 = 1;
        wait(0.5);
        myled1 = 0;
        wait(0.5);
        seconds = time(NULL);       
        lcd.cls();
        lcd.locate(0, 0);   // 1st line top
        lcd.printf("It is %d sec since Jan.1,1970\n", seconds); 
        lcd.locate(0, 1);   // 2nd line top
 #ifdef STYLE1
        //                  27 Mar 2010 13:24:00
        strftime(buf,40, "%x %X \n", localtime(&seconds));
 #endif
 #ifdef STYLE2
        //                 13:24:00 PM (2010/03/27)
        strftime(buf,40, "%I:%M:%S %p (%Y/%m/%d)\n", localtime(&seconds));
 #endif
        lcd.printf("Time = %s", buf);
        printf("Time = %s\r", buf);
    }
}

