/*
 * Mbed library program
 *  Control Piezo Transducer
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    Feburary  28th, 2018
 *      Revised:    March      3rd, 2018
 */

// Tested: Nucleo-F446RE with Akizuki PT08-Z185R
//      http://akizukidenshi.com/catalog/g/gP-01251/

/*
    Refrence:
        https://os.mbed.com/users/MikamiUitOpen/code/UIT_Sounder_OnOff/
        by 不韋 呂 さん(Mikami-san)
 */

#ifndef MBED_PIEZOBZ_H
#define MBED_PIEZOBZ_H

#include "mbed.h"

/**  Interface for Piezo Buzzer
 *
 * @code
 * #include "mbed.h"
 * #include "piezo_bz.h"
 *
 * PIEZO_BZ bz(D8, 3000U, 500U);   // 3kHz 0.5 sec duty
 *
 * int main() {
 *     while(1) {
 *         bz.start();
 *         wait(5.0f);
 *         bz.stop();
 *         wait(1.0f);
 *     }
 * }
 *
 * @endcode
 */

#define CONTINUOUS_MODE     0U

/** Piezo Buzzer class
 */
class PIEZO_BZ
{
public:

    /** Create a Piezo Buzzer instance
     *
     * @param pin for Piezo Buzzer (another pin connect GND)
     * @param Buzzer frequency [Hz]
     * @param Duration for ringing time and rest time (duty 50%) [mS]
     *          on_off_time = 0 -> Continuous mode
     */
    PIEZO_BZ(PinName pin, uint32_t freq, uint32_t on_off_time);

    /** Destructor of Piezo Buzzer
     */
    virtual ~PIEZO_BZ();

    /** Start Buzzer
     */
    void start(void);

    /** Stop Buzzer
     */
    void stop(void);

    /** Change buzzer frequency
     * @param Buzzer frequency [Hz]
     */
    void change_frequency(uint32_t freq);

    /** Change On-Off duration
     * @param Duration for ringing time and rest time (duty 50%) [mS]
     */
    void change_on_off(uint32_t on_off_time);

private:
    void create_freq_irq(void);
    void create_onoff_irq(void);

    DigitalOut  _pin;
    Ticker      _t0;
    Ticker      _t1;
    uint32_t    freq;
    uint32_t    t_onoff;
    bool        out;
    bool        flag_onoff;
    bool        flag_run;
    bool        flag_continuous;
};

#endif // MBED_PIEZOBZ_H
