/*
 * mbed Application program
 *      Redirect Standard Input/Output
 *
 * Copyright (c) 2021 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    January   13th, 2021
 *      Revised:    March      5th, 2021
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
static BufferedSerial pc(USBTX, USBRX, 9600);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
uint8_t readable()
{
    return pc.readable();
}

void putc(uint8_t c)
{
    char dt[4];
    dt[0] = (char)c;
    pc.write(dt, 1);
}

uint8_t getc()
{
    char dt[4];
    pc.read(dt, 1);
    return (uint8_t)dt[0];
}

//https://os.mbed.com/users/kenjiArai/code/Check_DeepSleep_os6/
void sleep_preparation()
{
    pc.enable_input(false);
    sleep_manager_can_deep_sleep();
}
