/*
 * Mbed Application program / Test SPI function
 *      Tested on Nucleo-F446RE
 *
 * Copyright (c) 2017 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    November   7th, 2017
 *      Revised:    November  16th, 2017
 */

/*
    --SPI1--
        SPI1_MOSI: PA_7  GPIO_AF5_SPI1
        SPI1_SCLK: PA_5  GPIO_AF5_SPI1
    --SPI2--
        SPI2_MOSI: PC_1  GPIO_AF7_SPI2
        SPI2_SCLK: PB_10 GPIO_AF5_SPI2
    --SPI3--
        SPI3_MOSI: PB_5  GPIO_AF6_SPI3
        SPI3_SCLK: PB_3  GPIO_AF6_SPI3
 
    --PortA--
        SPI1_MOSI: PA_7  GPIO_AF5_SPI1
        SPI1_SCLK: PA_5  GPIO_AF5_SPI1
    --PortB--
        SPI2_SCLK: PB_10 GPIO_AF5_SPI2
        SPI3_MOSI: PB_5  GPIO_AF6_SPI3
        SPI3_SCLK: PB_3  GPIO_AF6_SPI3
    --PortC--
        SPI2_MOSI: PC_1  GPIO_AF7_SPI2
 */

/*
    wiring information
    connected PA7(D11),PC_1(A4) and PB_5(D4)
    connected PA5(D13),PB_10(D6) and PB_3(D3)
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"

//  Definition -----------------------------------------------------------------
#define     DOES_NOT_WORK   1
#define     WORKS_WELL      0

#if (DOES_NOT_WORK + WORKS_WELL) != 1
#error "Please set either DOES_NOT_WORK or WORKS_WELL to 1”
#endif

//  Constructor ----------------------------------------------------------------
Serial      pc(USBTX, USBRX);
SPISlave    spi_1(PA_7 , NC, PA_5,  NC);
SPISlave    spi_2(PC_1 , NC, PB_10, NC);
SPI         spi_3(PB_5 , NC, PB_3);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
void print_port(void);
void print_spi(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main() {
    uint16_t spi1_data = 0;
    uint16_t spi2_data = 0;

    pc.printf("Start SPI Master & SPI Slave control program\r\n");
    spi_1.format(16, 3);    // 16bit, CPOL=1, CPHA=1
    spi_2.format(16, 3);
    spi_3.format(16, 3);
    print_port();
    print_spi();
#if WORKS_WELL
    // set register directly
        // original setting 0x8a33
        //  BIDIMODE(bit15) = 1 (why?)
        //  SPE(bit6) = 0 (when enbale SPI?)
        //  BR(bit5:3) = 110 -> fpclk/128 (correct)
    SPI1->CR1 = 0x0a73;
        // original setting 0x8a2b
        //  same as above SPI1
        //  in addition, BR(bit5:3) = 101 -> fpclk/64
        //      because SPI1 is APB2(max90MHz) and SPI2&3 are APB1(Max45MHz)
    SPI2->CR1 = 0x0a6b;     // 
    print_spi();
#elif DOES_NOT_WORK
    // no additional setting
    // Original setting
        // SPI1->CR1 = 0x8a33;
        // SPI2->CR1 = 0x8a2b;
#endif
    for (uint16_t i = 0;; i++){
        spi_3.write(i);
        wait_us(100);
        if (spi_1.receive() != 0){
            spi1_data = spi_1.read();// Read byte from master
        }
        if (spi_2.receive() != 0){
            spi2_data = spi_2.read();// Read byte from master
        }
        pc.printf("%d, %d, %d\r\n", i, spi1_data, spi2_data);
        if ((i != spi1_data) || (i != spi2_data)){
             pc.printf("Data unmatch!!\r\n");
        }
    }
}

void print_port(void)
{
    //---- Only for Debug purpose
        //  PA
    pc.printf("PA7/AF5,PA5/AF5,PA4/AF5\r\n");
    pc.printf("PA7/AF5(SPI1/MOSI),PA5/AF5(SPI1/SCLK)\r\n");
    pc.printf("PA->\r\n");
    pc.printf("AFRL    0x%08x:0x%08x\r\n",&GPIOA->AFR[0], GPIOA->AFR[0]);
    pc.printf("AFRH    0x%08x:0x%08x\r\n",&GPIOA->AFR[1], GPIOA->AFR[1]);
    pc.printf("MODER   0x%08x:0x%08x\r\n",&GPIOA->MODER, GPIOA->MODER);
    pc.printf("PUPDR   0x%08x:0x%08x\r\n",&GPIOA->PUPDR, GPIOA->PUPDR);
    pc.printf("OTYPER  0x%08x:0x%08x\r\n",&GPIOA->OTYPER, GPIOA->OTYPER);
    pc.printf("OSPEEDR 0x%08x:0x%08x\r\n",&GPIOA->OSPEEDR, GPIOA->OSPEEDR);
        //  PB
    pc.printf("PB10/AF5(SPI2/SCLK),PB5/AF6(MOSI),PB3/AF6(SCLK)\r\n");
    pc.printf("PB->\r\n");
    pc.printf("AFRL    0x%08x:0x%08x\r\n",&GPIOB->AFR[0], GPIOB->AFR[0]);
    pc.printf("AFRH    0x%08x:0x%08x\r\n",&GPIOB->AFR[1], GPIOB->AFR[1]);
    pc.printf("MODER   0x%08x:0x%08x\r\n",&GPIOB->MODER, GPIOB->MODER);
    pc.printf("PUPDR   0x%08x:0x%08x\r\n",&GPIOB->PUPDR, GPIOB->PUPDR);
    pc.printf("OTYPER  0x%08x:0x%08x\r\n",&GPIOB->OTYPER, GPIOB->OTYPER);
    pc.printf("OSPEEDR 0x%08x:0x%08x\r\n",&GPIOB->OSPEEDR, GPIOB->OSPEEDR);
        //  PC
    pc.printf("PC1/AF7(SPI2/MOSI)\r\n");
    pc.printf("PC->\r\n");
    pc.printf("AFRL    0x%08x:0x%08x\r\n",&GPIOC->AFR[0], GPIOC->AFR[0]);
    pc.printf("AFRH    0x%08x:0x%08x\r\n",&GPIOC->AFR[1], GPIOC->AFR[1]);
    pc.printf("MODER   0x%08x:0x%08x\r\n",&GPIOC->MODER, GPIOC->MODER);
    pc.printf("PUPDR   0x%08x:0x%08x\r\n",&GPIOC->PUPDR, GPIOC->PUPDR);
    pc.printf("OTYPER  0x%08x:0x%08x\r\n",&GPIOC->OTYPER, GPIOC->OTYPER);
    pc.printf("OSPEEDR 0x%08x:0x%08x\r\n",&GPIOC->OSPEEDR, GPIOC->OSPEEDR);
}

void print_spi(void)
{
        //  SPI1
    pc.printf("Set to SPISlave\r\n");    
    pc.printf("SPI1->\r\n");
    pc.printf("CR1   0x%08x:0x%04x\r\n",&SPI1->CR1, SPI1->CR1);
    pc.printf("CR2   0x%08x:0x%04x\r\n",&SPI1->CR2, SPI1->CR2);
    pc.printf("SR    0x%08x:0x%04x\r\n",&SPI1->SR,  SPI1->SR);
    pc.printf("DR    0x%08x:0x%04x\r\n",&SPI1->DR,  SPI1->DR);
        //  SPI2
    pc.printf("Set to SPISlave\r\n"); 
    pc.printf("SPI2->\r\n");
    pc.printf("CR1   0x%08x:0x%04x\r\n",&SPI2->CR1, SPI2->CR1);
    pc.printf("CR2   0x%08x:0x%04x\r\n",&SPI2->CR2, SPI2->CR2);
    pc.printf("SR    0x%08x:0x%04x\r\n",&SPI2->SR,  SPI2->SR);
    pc.printf("DR    0x%08x:0x%04x\r\n",&SPI2->DR,  SPI2->DR);
        //  SPI3
    pc.printf("Set to SPI (Master)\r\n"); 
    pc.printf("SPI3->\r\n");
    pc.printf("CR1   0x%08x:0x%04x\r\n",&SPI3->CR1, SPI3->CR1);
    pc.printf("CR2   0x%08x:0x%04x\r\n",&SPI3->CR2, SPI3->CR2);
    pc.printf("SR    0x%08x:0x%04x\r\n",&SPI3->SR,  SPI3->SR);
    pc.printf("DR    0x%08x:0x%04x\r\n",&SPI3->DR,  SPI3->DR);
}
