/*
 * MUTEX ERROR reproduce program on OS5.10.x
 *      by Kenji Arai / JH1PJL on October   20th, 2018
 */

/*
 on 5.9.7/18 Sep 2018               -> works well
 on 5.10.0/3weeks, 3dyas a go       -> Mutex lock failed, error=0x80020115
 on 5.10.1/1weeks,1day ago          -> Mutex lock failed, error=0x80020115
 on 5.10.2/12hours, 12minutes ago   -> Mutex lock failed, error=0x80020115
 */

#include "mbed.h"

//    RUN ONLY ON mbed-os5.9.7
#if (MBED_MAJOR_VERSION == 5) &&\
    (MBED_MINOR_VERSION == 10)
    // correct mbed-os version
#else
    #warning "Not use Mbed-os5.10.x"
#endif

Serial  pc(USBTX, USBRX);

CircularBuffer<char, 1024> rxbuf;    // PC receiving Buffer

void rx_handler(void)
{
    if (pc.readable()) {
        rxbuf.push(pc.getc());
    }
}

int main()
{
    char dt = 0;

    rxbuf.reset();
    pc.attach(&rx_handler, Serial::RxIrq);
    while(true){
        if (!rxbuf.empty()){  // wait receiving a character
            rxbuf.pop(dt);
            pc.putc(dt);
        }
    }
}

