/*
 * mbed Application program for the mbed LPC1114FN28
 * Data Logging 
 *
 * Copyright (c) 2013,'14 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: June      16th, 2013
 *      Revised: July       3rd, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _DT_LOG_H_
#define _DT_LOG_H_

//  Definition  -----------------------------------------------------------------------------------
// Buffer size
#define EEP_SIZE    128 * 1024  // 1Mbits = 128 KBytes
#define PKT_SIZE    16          // Packet size
#define BLK_NO      8192        // 128KB/16 = 8192
#define ALL_SIZE    (PKT_SIZE) * (BLK_NO)
#if ALL_SIZ > EEP_SIZE
#error "Data size in EEPROM is too big!"
#endif
#define PTR_SIZE    16

// Buffer control
#define RING_TOP    1
#define RING_TAIL   (BLK_NO - RING_TOP -1)
#define BLK_SIZE    16

//  Function prototypes ---------------------------------------------------------------------------
void dtlog_data_pack(void);
void dtlog_one_write(void);
uint16_t dtlog_buf_occupation(void);

#endif  // _DT_LOG_H_
