/*
 * mbed Application program
 *      Redirect Standard Input/Output
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created: August     7th, 2020
 *      Revised: August     7th, 2020
 */

extern BufferedSerial pc;

FileHandle *mbed::mbed_override_console(int fd);

inline uint8_t readable(void)
{
    return pc.readable();
}

inline void putc(uint8_t c)
{
    char dt = c;
    pc.write(&dt, 1);
}

inline uint8_t getc(void)
{
    int c = getchar();
    return (uint8_t)c;
}

inline void puts_wo_cr(char *bf, uint32_t len)
{
    pc.write(bf, len);
}
