/*
 * mbed Application program for the mbed LPC1114FN28
 *
 * Copyright (c) 2014,'20,'21 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created: September 14th, 2014
 *      Revised: September 21st, 2014
 *      Revised: February  27th, 2021
 */
/*
    Tested LCD
        1) AD-12864-SPI / 128 x 64 dots / Interface: SPI
            http://www.aitendo.com/product/1622

            1)CSI  2)RES  3)A0  4)SCK  5)SDI  6)3.3V  7)GND  8)LED_A
              dp9    dp10   dp4   dp6    dp2    +3.3V   GND    +3.3V(51 ohm)

        2) AE-AQM1248(AQM1248A-RN-FBW-P) / 128 x 48 dots / Interface: SPI
            http://akizukidenshi.com/catalog/g/gK-07007/
            http://akizukidenshi.com/catalog/g/gP-07005/

            1)VDD  2)/CS  3)/RES  4)RS  5)SCLK  6)SDI  7)GND
              +3.3V  dp9    dp10    dp4   dp6     dp2    GND
 */

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "ST7565_SPI_LCD.h"
#include    "uart_as_stdio.h"

//  Definition -----------------------------------------------------------------
//#define AITENDO
#define AKIZUKI

#if defined(AITENDO) && defined(AKIZUKI)
#   error "Please choose one!!"
#elif defined(AITENDO)
#   define MAX_Y        64
#   define CONTRAST     0x32
#elif defined(AKIZUKI)
#   define MAX_Y        48
#   define CONTRAST     0x24
#else
#   error "Please choose AKIZUKI or AITENDO"
#endif

#define Y0   (MAX_Y - 2)
#define Y1   (MAX_Y - 9)
#define Y2   (MAX_Y - 1)

//#define ADJ_CONTRAST

//  Object ---------------------------------------------------------------------
// LED
DigitalOut  myled(dp28);

// SPI LCD
#if defined(AITENDO)
#   if 1
//              mosi, sck, reset, a0, ncs
ST7565      lcd(dp2, dp6, dp10, dp4, dp9, ST7565::AD12864SPI);
#   else
//                  mosi, miso, sck
SPI         spi_lcd(dp2, dp1, dp6);
//              spi, reset, a0, ncs
ST7565      lcd(spi_lcd, dp10, dp4, dp9, ST7565::AD12864SPI);
#   endif
#elif defined(AKIZUKI)
//              mosi, sck, reset, a0, ncs
ST7565      lcd(dp2, dp6, dp10, dp4, dp9, ST7565::AQM1248A);
#endif

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
extern void print_revision(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint8_t c;

    print_revision();
    myled = 0;
    lcd.cls();
    lcd.set_contrast(CONTRAST);
    lcd.printf("test\r\n" );
    lcd.printf("Run on  Mbed-os%d.%d.%d\r\n",
               MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
    lcd.printf("1234567890 ABCDEFG\r\n" );
    //lcd.rect(5,30,120,62,1);
    lcd.rect(5,30,120,Y0,1);
    lcd.circle(5,35,5,1);
    //lcd.fillcircle(60,55,5,1);
    lcd.fillcircle(60,Y1,5,1);
    //lcd.line(0,30,127,63,1);
    lcd.line(0,30,127,Y2,1);
    printf("Graphic Display example, bin file created on " __DATE__ ".\r\n");
    printf("You can see something on the LCD screen.\r\n");
    printf("H:%d W:%d\r\n", lcd.height(), lcd.width());
    while(true) {
#ifndef ADJ_CONTRAST
        myled = !myled;
        c = getc();
        putc(c);
        if (c == '\b') {    // Enter Back Space
            myled = 0;
            break;
        }
        lcd.putc(c);
#else
        // check best contrast
        printf("Entered contrast adjustment mode.\r\n");
        uint8_t px = CONTRAST;
        while(true) {
            lcd.set_contrast(px);
            printf("0x%x\r\n",px);
            c = getc();
            if ((c == '-') || (c == 'd')) {
                if (px != 0) {
                    --px;
                }
            } else {
                if (px < 0x40) {
                    ++px;
                }
            }
        }
#endif
    }
    while(true) {
        uint8_t i,k = 0;
        i = 10 - k;
        k++;
        c = getc();
        lcd.cls();
        lcd.rect(10, i, 100, Y1, 1);
        c = getc();
        lcd.circle(10,10,i,1);
        c = getc();
        lcd.fillcircle(50,40,i,1);
        c = getc();
        lcd.line(0, 0, 110-i, Y1, 1);
        c = getc();
        if (c == '\b') {    // Enter Back Space
            myled = 0;
            break;
        }
    }
    lcd.cls();
    lcd.locate(10, 10);
    lcd.printf("JH1PJL  Mbed-os%d.%d.%d\r\n",
               MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
    while(true) {
        ThisThread::sleep_for(100s);
    }
}
