/*
 * Mbed Application program
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      5th, 2020
 *      Revised:    April     13th, 2020
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define KEY4X5
#ifdef KEY4X5

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Keypad.h"

//  Definition -----------------------------------------------------------------

//  Object ---------------------------------------------------------------------
DigitalOut  my_led(LED1);
Serial      pc(USBTX,USBRX);
//              X    Y    Z   W    A   B   C   D   E   OUT(XYZW), IN(ABCDE)
Keypad      key(D11, D10, D9, D8, D6, D5, D4, D3, D2);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
//                          X*A = *, X*B = D, X*C = 9, X*D = 5, X*E = 1
//                          Y*A = /, Y*B = E, Y*C = A, Y*D = 6, Y*E = 2
//                          Z*A = #, Z*B = F, Z*C = B, Z*D = 7, Z*E = 3
//                          W*A = +, W*B = G, W*C = C, W*D = 8, W*E = 4
//                          key_table[0]=? is not used!
const char *const key_table = "?*D951/EA62#FB73+GC84";
//                              12345678901234567890

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t key_num;
    uint32_t counter = 0;

    pc.printf("Start Key-Pad test 4x5 keys\r\n");
    while(true) {
        while ((key_num = key.read()) != 0) {
            pc.printf("%2u:[%2d] %c\r\n",
                      counter++, key_num, *(key_table + key_num));
        }
        wait_us(100000);
    }
}

#endif  // #ifdef KEY4X5