/*
 * Mbed Application program
 *  example:
 *      Akizuki AE-KIT45-KEYPAD4X3
 *      http://akizukidenshi.com/catalog/g/gK-12229/
 *
 * Copyright (c) 2017,'20 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    September 27th, 2017
 *      Revised:    April     13th, 2020
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define KEY3X4
#ifdef KEY3X4

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Keypad.h"

//  Definition -----------------------------------------------------------------

//  Object ---------------------------------------------------------------------
DigitalOut  my_led(LED1);
Serial      pc(USBTX,USBRX);
//              X    Y    Z   A   B   C   D   OUT(XYZ), IN(ABCD)
Keypad      key(D11, D10, D9, D6, D5, D4, D3);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
//                          X*A = *, X*B = 7, X*C = 4, X*D = 1
//                          Y*A = 0, Y*B = 8, Y*C = 5, Y*D = 2
//                          Z*A = #, Z*B = 9, Z*C = 6, Z*D = 3
//                          key_table[0]=? is not used!
const char *const key_table = "?*7410852#963";
//                              123456789012

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t key_num;
    uint32_t counter = 0;

    pc.printf("Start Key-Pad test 3x4 keys\r\n");
    while(true) {
        while ((key_num = key.read()) != 0) {
            pc.printf("%2u:[%2d] %c\r\n",
                      counter++, key_num, *(key_table + key_num));
        }
        wait_us(100000);
    }
}

#endif  // #ifdef KEY3X4