/*
 * Check Mbed revision
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Revised:    Feburary  16th, 2020
 *      Revised:    April      6th, 2020
 */

#include "mbed.h"

// RUN on mbed-os-6.0.0-alpha-3
//    https://github.com/ARMmbed/mbed-os/releases/tag/mbed-os-6.0.0-alpha-3
#if   (MBED_MAJOR_VERSION == 5) &&\
      (MBED_MINOR_VERSION == 15) &&\
      (MBED_PATCH_VERSION == 1)
// RUN on mbed 2.0.165
#elif (MBED_MAJOR_VERSION == 2) &&\
      (MBED_MINOR_VERSION == 0) &&\
      (MBED_PATCH_VERSION == 165)
#else
#     error "Please use mbed-os-6.0.0-alpha-3 or mbed2-165"
#endif

void print_revision(void)
{
    printf("MBED_MAJOR_VERSION = %d, ", MBED_MAJOR_VERSION);
    printf("MINOR = %d, ", MBED_MINOR_VERSION);
    printf("PATCH = %d\r\n", MBED_PATCH_VERSION);
}
