/*
 * Mbed Application program
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      5th, 2020
 *      Revised:    February  18th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define COMPLEX
#ifdef COMPLEX

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Keypad.h"

//  Definition -----------------------------------------------------------------
#define A_SW    24      // see key_table[25] = A
#define B_SW     3      // see key_table[3]  = B
#define C_SW     8      // see key_table[8]  = C

#if (MBED_MAJOR_VERSION == 2) || (MBED_MAJOR_VERSION == 5)
#   define  WAIT_100MS()     {wait_us(100000);}
#else
#   define  WAIT_100MS()     {ThisThread::sleep_for(100ms);}
#endif

//  Object ---------------------------------------------------------------------
DigitalOut  my_led(D13);
//DigitalOut  my_led(LED1);
DigitalOut  led0(A0);
DigitalOut  led1(A1);
DigitalOut  led2(A2);
//              X    Y    Z   W   V   A   B   C   D   E   OUT(XYZWV), IN(ABCDE)
Keypad      key(D11, D10, D9, D8, D7, D6, D5, D4, D3, D2);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
//                       key_table[0]=? is not used!
//                         1     2     3     4     5
const char key_table[] = {NUL,
                          '*',  'G',  'B',  '6',  '1',    // 1
                          '/',  'H',  'C',  '7',  '2',    // 2
                          CR,   '-',  'D',  '8',  '3',    // 3
                          SPC,  '+',  'E',  '9',  '4',    // 4
                          BS,   '=',  'F',  'A',  '5',    // 5
                          NUL
                         };

//  Function prototypes --------------------------------------------------------
extern void print_revision(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t key_num;
    uint32_t counter = 0;

    print_revision();
    printf("Start Key-Pad test 5x5 keys and/or state hold switch\r\n");
    while(true) {
        while ((key_num = key.read()) != 0) {
            printf("%2u:[%2d] %c\r\n",
                      counter++, key_num, key_table[key_num]);
        }
        if (key.read_state(A_SW) == true) {
            led0 = 1;
        } else {
            led0 = 0;
        }
        if (key.read_state(B_SW) == true) {
            led1 = 1;
        } else {
            led1 = 0;
        }
        if (key.read_state(C_SW) == true) {
            led2 = 1;
        } else {
            led2 = 0;
        }
        WAIT_100MS();
    }
}

#endif  // #ifdef COMPLEX