/*
 * Mbed Application program
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      5th, 2020
 *      Revised:    February  18th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define KEY4X4
#ifdef KEY4X4

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Keypad.h"

//  Definition -----------------------------------------------------------------
#if (MBED_MAJOR_VERSION == 2) || (MBED_MAJOR_VERSION == 5)
#   define  WAIT_100MS()     {wait_us(100000);}
#else
#   define  WAIT_100MS()     {ThisThread::sleep_for(100ms);}
#endif

//  Object ---------------------------------------------------------------------
DigitalOut  my_led(LED1);
//              X    Y    Z   W    A   B   C   D   OUT(XYZW), IN(ABCD)
Keypad      key(D11, D10, D9, D8, D6, D5, D4, D3);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
//                          X*A = *, X*B = 7, X*C = 4, X*D = 1
//                          Y*A = 0, Y*B = 8, Y*C = 5, Y*D = 2
//                          Z*A = #, Z*B = 9, Z*C = 6, Z*D = 3
//                          W*A = A, W*B = B, W*C = C, W*D = D
//                          key_table[0]=? is not used!
const char *const key_table = "?*7410852#963ABCD";
//                              1234567890123456

//  Function prototypes --------------------------------------------------------
extern void print_revision(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t key_num;
    uint32_t counter = 0;

    print_revision();
    printf("Start Key-Pad test 4x4 keys\r\n");
    while(true) {
        while ((key_num = key.read()) != 0) {
            printf("%2u:[%2d] %c\r\n",
                      counter++, key_num, *(key_table + key_num));
        }
        WAIT_100MS();
    }
}

#endif  // #ifdef KEY4X4