/*
 * Mbed Application program
 *
 * Copyright (c) 2020,'21 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      5th, 2020
 *      Revised:    February  18th, 2021
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define KEY5X5
#ifdef KEY5X5

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Keypad.h"

//  Definition -----------------------------------------------------------------
#if (MBED_MAJOR_VERSION == 2) || (MBED_MAJOR_VERSION == 5)
#   define  WAIT_100MS()     {wait_us(100000);}
#else
#   define  WAIT_100MS()     {ThisThread::sleep_for(100ms);}
#endif

//  Object ---------------------------------------------------------------------
DigitalOut  my_led(LED1);
//              X    Y    Z   W   V   A   B   C   D   E   OUT(XYZWV), IN(ABCDE)
Keypad      key(D11, D10, D9, D8, D7, D6, D5, D4, D3, D2);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
//                          X*A = *, X*B = G, X*C = B, X*D = 6, X*E = 1
//                          Y*A = /, Y*B = H, Y*C = C, Y*D = 7, Y*E = 2
//                          Z*A = ., Z*B = I, Z*C = D, Z*D = 8, Z*E = 3
//                          W*A = +, W*B = J, W*C = E, W*D = 9, W*E = 4
//                          V*A = -, V*B = =, V*C = F, V*D = A, V*E = 5
//                          key_table[0]=? is not used!
const char *const key_table = "?*GB61/HC72.ID83+JE94-=FA5";
//                              1234567890123456789012345

//  Function prototypes --------------------------------------------------------
extern void print_revision(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t key_num;
    uint32_t counter = 0;

    print_revision();
    printf("Start Key-Pad test 5x5 keys\r\n");
    while(true) {
        while ((key_num = key.read()) != 0) {
            printf("%2u:[%2d] %c\r\n",
                      counter++, key_num, *(key_table + key_num));
        }
        WAIT_100MS();
    }
}

#endif  // #ifdef KEY5X5