//------- Feburary 6th, 2018 by JH1PJL / K.Arai --------------------------------
// Tested on Nucleo-F446RE and my handmade VL53L0X board
//  https://os.mbed.com/users/kenjiArai/notebook/vl53l0x-tof-sensor/
#error "You will have real error when you try this sample program!!"
// If you use I2C class constractor you may have an error.
// You need to modify as follows.
// 1)    line 4 of this file -> delete or comment out
// 2)    /HelloWorld_53L0A1_with_I2C_device/X_NUCLEO_53L0A1/
//                                    Components/VL53L0X/VL53L0X_i2c_platform.h
//          line 55 #define I2C  0x01 -> delete or comment out
//          line 56 #define SPI  0x00 -> delete or comment out
#define ADDED
//------------------------------------------------------------------------------

#include "mbed.h"
#ifndef ADDED
#include "XNucleo53L0A1.h"
#else
#include "VL53L0X.h"
#include "TextLCD.h"
#endif
#include <stdio.h>

/* This VL53L0X Expansion board test application performs a range measurement in polling mode
   on the onboard embedded top sensor. */

#define VL53L0_I2C_SDA   D14 
#define VL53L0_I2C_SCL   D15

#ifndef ADDED
static XNucleo53L0A1 *board=NULL;
#else
static VL53L0X *board=NULL;
DigitalOut xshut(D10);  // connection for XSHUT is MUST!! 
I2C i2c(I2C_SDA, I2C_SCL);
TextLCD_I2C_N lcd(&i2c, 0x7c, TextLCD::LCD8x2);  // LCD(Akizuki  AQM0802A)
#endif

/*=================================== Main ==================================
=============================================================================*/
int main()
{   
   int status;
   uint32_t distance;

#ifdef ADDED
    lcd.locate(0, 0);
    //        12345678
    lcd.puts("12345678");
    lcd.locate(0, 1);
    //        12345678
    lcd.puts(" JH1PJL ");
    lcd.setCursor(TextLCD_Base::CurOff_BlkOff);
    lcd.setContrast(0x19);
    wait(1.0f);
#endif

    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    
    /* creates the 53L0A1 expansion board singleton obj */
#ifndef ADDED
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
#else
    //--- xshut is mandantory (if xshut=NC then not run the program)
    board = new VL53L0X(device_i2c, &xshut, NC);
#endif
#ifndef ADDED
    /* init the 53L0A1 expansion board with default values */
    status = board->init_board();
#else
    status = board->init_sensor(0x33 << 1U);
#endif
    if (status) {
        printf("Failed to init board!\r\n");
        return 0;
    }
   while (1) {
#ifndef ADDED
        status = board->sensor_centre->get_distance(&distance);
#else
        status = board->get_distance(&distance);
#endif
        if (status == VL53L0X_ERROR_NONE) {
           printf("Distance : %ld\r\n", distance);
        }
#ifdef ADDED
        lcd.locate(0, 0);
        //          12345678
        lcd.printf("Dist.:mm");
        lcd.locate(0, 1);
        lcd.printf(" %5d  ", distance);
#endif
   }
}
