/*
 * mbed Application program for the mbed
 *      Test program for GR-PEACH
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: November  29th, 2014
 *      Revised: January   10th, 2015
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//  Include ---------------------------------------------------------------------------------------
#include    "mbed.h"
#include    "L3GD20.h"
#include    "LIS3DH.h"
#include    "TextLCD.h"

//  Definition ------------------------------------------------------------------------------------
#define USE_COM         // use Communication with PC(UART)
#define USE_I2C_LCD
#define USE_I2C_SENSOR
 
// Com
#ifdef  USE_COM
#define BAUD(x)             pcx.baud(x)
#define GETC(x)             pcx.getc(x)
#define PUTC(x)             pcx.putc(x)
#define PRINTF(...)         pcx.printf(__VA_ARGS__)
#define READABLE(x)         pcx.readable(x)
#else
#define BAUD(x)             {;}
#define GETC(x)             {;}
#define PUTC(x)             {;}
#define PRINTF(...)         {;}
#define READABLE(x)         {;}
#endif

//  Object ----------------------------------------------------------------------------------------
// LED's
DigitalOut LEDs[4] = {
    DigitalOut(LED1), DigitalOut(LED2), DigitalOut(LED3), DigitalOut(LED4)
};
// Swiches
DigitalIn   USER_SWITCH[2] = {
    #if defined(TARGET_RZ_A1H)
    DigitalIn(P6_0),  DigitalIn(P6_1)
    #elif defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F411RE)\
     || defined(TARGET_NUCLEO_L152RE)
    DigitalIn(PC_13),  DigitalIn(A0)
    #elif defined(TARGET_LPC1768)
    DigitalIn(A0),  DigitalIn(A1)
    #elif defined(TARGET_K64F)
    DigitalIn(PTA4),  DigitalIn(PTC6)
    #endif
};
// com
#ifdef USE_COM
Serial      pcx(USBTX, USBRX);      // Communication with Host
#endif
I2C i2c(D14,D15);
// Gyro
L3GX_GYRO   gyro(i2c, L3GD20_V_CHIP_ADDR, L3GX_DR_95HZ, L3GX_BW_HI, L3GX_FS_250DPS);
// Acc
LIS3DH      acc(i2c, LIS3DH_G_CHIP_ADDR, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_8G);
#ifdef USE_I2C_LCD
// LCD
TextLCD_I2C_N lcd0(&i2c, 0x7c, TextLCD::LCD16x2);  // LCD(Akizuki AQM0802A)
#endif

//  RAM -------------------------------------------------------------------------------------------
float fa[3];    // Acc  0:X, 1:Y, 2:Z
float fg[3];    // Gyro 0:X, 1:Y, 2:Z

uint8_t show_flag;
uint32_t count;

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
void blink(void const *n) {
    LEDs[(int)n] = !LEDs[(int)n];
}

// Read switch status
int read_sw(uint8_t n){
    if (USER_SWITCH[n] == 0){   return 1;
    } else {                    return 0;}
}

// Update sensor data
void update_angle(void){
#ifdef USE_I2C_SENSOR
    // read acceleration data from sensor
    acc.read_data(fa);
    // read gyroscope data from sensor
    gyro.read_data(fg);
#else
    fa[0] = fa[1] = fa[2] = 1.11f;
    fg[0] = fg[1] = fg[2] = 1.11f;
#endif
}

// Update sensor data
void display(void){
#ifdef USE_I2C_LCD
    lcd0.locate(0, 0);    // 1st line top
    lcd0.printf(" G=%4.1f ", sqrt(fa[0]*fa[0] + fa[1]*fa[1] + fa[2]*fa[2]));
    lcd0.locate(0, 1);    // 2nd line top
    lcd0.printf("%8d",count++);
#endif
}

void send_pc(void){
    PRINTF("G:%+6.1f,%+6.1f,%+6.1f,  ", fg[0], fg[1], fg[2]);
    PRINTF("A:%+6.1f,%+6.1f,%+6.1f \r\n", fa[0], fa[1], fa[2]);
}

int main(void) {
    // I2C LCD
#ifdef USE_I2C_LCD
    lcd0.locate(0, 0);    // 1st line top
    lcd0.printf("I2C test");
    lcd0.locate(0, 1);    // 2nd line top
    lcd0.puts(" JH1PJL ");
    lcd0.setContrast(0x14);
#endif
    count = 0; 
    while (true) {
        update_angle();
        display();
        send_pc();
        //wait(0.2);
        blink((void *)0);
        //wait(0.2);
        blink((void *)1);
        //wait(0.2);
        blink((void *)2);
        //wait(0.2);
        blink((void *)3);
        //wait(0.2);
    }
}
