/*
 * mbed Application program for the mbed
 *      Test program for GR-PEACH
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: November  29th, 2014
 *      Revised: November  30th, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"

//  Object ----------------------------------------------------------------------------------------
Timer timer;
DigitalOut myled(LED1);

//  Definition ------------------------------------------------------------------------------------
#define ON  0
#define OFF 1

//  RAM -------------------------------------------------------------------------------------------

//  ROM / Constant data ---------------------------------------------------------------------------
#if defined(TARGET_RZ_A1H)
char *const msg = "Start measurement on TARGET_RZ_A1H";
#elif defined(TARGET_LPC1114)
char *const msg = "Start measurement on TARGET_LPC1114";
#elif defined(TARGET_NUCLEO_F411RE)
char *const msg = "Start measurement on TARGET_NUCLEO_F411RE";
#elif defined(TARGET_LPC1768)
char *const msg = "Start measurement on TARGET_LPC1768";
#elif defined(TARGET_K64F)
char *const msg = "Start measurement on TARGET_K64F";
#endif

//  Function prototypes ---------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
int main()
{
    float ts = 0, te = 0;
    uint32_t i=0;

    printf("\r\n%s\r\n", msg);
    timer.start();
    ts = timer.read_us();
    for (i=0; i < 1000; i++) {
        myled = !myled;
    }
    te = timer.read_us();
    printf("Running speed %.4f[uS]\r\n", (te - ts) / i);
    while(true) {
        ;
    }
}
