/*
 * mbed Application program for the mbed
 *      Test program for GR-PEACH
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: December  27th, 2014
 *      Revised: December  28th, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//  Include ---------------------------------------------------------------------------------------
#include    "mbed.h"
//  Object ----------------------------------------------------------------------------------------
extern Serial pc(USBTX, USBRX);

//  Definition ------------------------------------------------------------------------------------
#define BAUD_RATE 9600

#define BAUD(x)             pc.baud(x)
#define GETC(x)             pc.getc(x)
#define PUTC(x)             pc.putc(x)
#define PRINTF(...)         pc.printf(__VA_ARGS__)
#define READABLE(x)         pc.readable(x)

#define BUF_SIZE            (128 * 1024)  // 128KB
#define BUF_SIZE_SMALL      (40 * 1024)

//  Object ----------------------------------------------------------------------------------------

//  RAM -------------------------------------------------------------------------------------------
uint8_t data_buf0[BUF_SIZE];
uint8_t data_buf1[BUF_SIZE];
uint8_t data_buf2[BUF_SIZE];
uint8_t data_buf3[BUF_SIZE_SMALL];
//uint8_t data_buf2[BUF_SIZE] __attribute__ ((RW_DATA));

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
extern int mon_mem(void);

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
void print_data_address(void)
{
    PRINTF("data_buf0 addr top: 0x%8x\r\n", &data_buf0);
    PRINTF("data_buf1 addr top: 0x%8x\r\n", &data_buf1);
    PRINTF("data_buf2 addr top: 0x%8x\r\n", &data_buf2);
    PRINTF("data_buf3 addr top: 0x%8x\r\n", &data_buf3);
}

int main()
{
    uint32_t n;

    PRINTF("\r\nSet data into data_buf0[]\r\n");
    for (n = 0; n < BUF_SIZE; n++) {
        data_buf0[n] = n & 0xff;
    }
    PRINTF("Set data into data_buf1[]\r\n");
    for (n = 0; n < BUF_SIZE; n++) {
        data_buf1[BUF_SIZE - n] = n & 0xff;
    }
    PRINTF("Set data into data_buf2[]\r\n");
    for (n = 0; n < BUF_SIZE; n++) {
        data_buf2[n] = n & 0xff;
    }
    PRINTF("Set data into data_buf3[]\r\n");
    for (n = 0; n < BUF_SIZE_SMALL; n++) {
        data_buf3[n] = n & 0xff;
    }
    print_data_address();
    while (true) {
        mon_mem();
    }
}
