/*
 * mbed Application program for the mbed
 *      Test program for GR-PEACH
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: November  29th, 2014
 *      Revised: November  29th, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"

//#define PIN_NUM
#define LED_NAME
//#define LED_COLOR

#define DISP_COM

// Com
#ifdef DISP_COM
#define BAUD(x)           pcm.baud(x)
#define PRINTF(...)       pcm.printf(__VA_ARGS__)
#else
#define BAUD(x)           baud(x)
#define PRINTF(...)       printf(__VA_ARGS__)
#endif

#ifdef DISP_COM
// com
Serial pcm(USBTX, USBRX);
#endif

#if defined(PIN_NUM)
DigitalOut myledR(P4_4);
DigitalOut myledG(P3_2);
DigitalOut myledB(P4_6);
DigitalOut myledU(P4_7);
#elif defined(LED_NAME)
DigitalOut myledR(LED1);
DigitalOut myledG(LED2);
DigitalOut myledB(LED3);
DigitalOut myledU(LED4);
#elif defined(LED_COLOR)
DigitalOut myledR(LED_RED);
DigitalOut myledG(LED_GREEN);
DigitalOut myledB(LED_BLUE);
DigitalOut myledU(LED_USER);
#endif

#define ON  0
#define OFF 1

int main() {
    uint32_t n = 0;
    
    PRINTF("Start mbed program\r\n");
    myledR = OFF;
    PRINTF("RF,");
    myledG = OFF;
    PRINTF("GF,");
    myledB = OFF;
    PRINTF("BF,");
    myledU = ON;
    PRINTF("UN");
    while(1) {
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=ON ,G=OFF,B=OFF ");
        myledR = ON;
        PRINTF("RN,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = OFF;
        PRINTF("UF");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=OFF,B=OFF ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = ON;
        PRINTF("UN");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=ON ,B=OFF ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = ON;
        PRINTF("GN,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = OFF;
        PRINTF("UF");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=OFF,B=OFF ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = ON;
        PRINTF("UN");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=OFF,B=ON  ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = ON;
        PRINTF("BN,");
        myledU = OFF;
        PRINTF("UF");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=OFF,B=OFF ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = ON;
        PRINTF("UN");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=ON ,G=ON ,B=ON  ");
        myledR = ON;
        PRINTF("RN,");
        myledG = ON;
        PRINTF("GN,");
        myledB = ON;
        PRINTF("BN,");
        myledU = OFF;
        PRINTF("UF");
        wait(5.0);
        PRINTF(" passed %4d Sec\r\n", n +=5);
        PRINTF("R=OFF,G=OFF,B=OFF ");
        myledR = OFF;
        PRINTF("RF,");
        myledG = OFF;
        PRINTF("GF,");
        myledB = OFF;
        PRINTF("BF,");
        myledU = ON;
        PRINTF("UN");
    }
}
