/*
 * mbed Application program / GPS receiver control and 1PPS output
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: March     28th, 2004   Kenji Arai
 *      updated: July      25th, 2009   for PIC24USB
 *      updated: January   16th, 2010   change to GPS-GM318
 *      updated: April     24th, 2010   for mbed / NXP LPC1768
 *      Revised: January    1st, 2015
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/*
    PA6C GPS Module
        current setting: GGA,RMC
 */

//  Definition ------------------------------------------------------------------------------------
//  GPS data selection & buffer size
/* $GPGAA,hhmmss.sss,ddmm.mmmmmm,N,dddmm.mmmmmm,
        E,1,xx,xx.xx,xx.xxx,M,xx.xxx,M,s.ss,xxxx*sum<CR><LF>
    ex. $GPGGA,060306.00,4344.77894,N,14223.38857,
        E,2,11,0.9,128.4,M,28.8,M,5.0,0129*4C<CR><LF>
    # of data (ex.) = 81
*/
#define     SIZE_BUF_GGA    96
/*
 $GPGSA,A,3,xx,xx,,,xx,xx,,,,,xx.x,xx.x,xx.x*sum<CR><LF>
    ex. $GPGSA,A,3,03,06,13,16,21,23,24,25,29,31,42,50,1.9,0.9,1.7*3C
    # of data (ex.) = 63
*/
#define     SIZE_BUF_GSA    80
/*
 $GPGSV,x,x,xx*sum<CR><LF>
    ex. $GPGSV,3,1,12,03,39,225,47,06,55,217,48,13,21,314,48,16,74,342,50*76
        $GPGSV,3,2,12,21,33,095,50,23,32,280,50,24,18,049,42,25,12,315,43*7E
        $GPGSV,3,3,12,29,12,047,45,31,49,146,49,42,39,183,46,50,39,176,42*7C
    # of data (ex.) = 70
*/
#define     SIZE_BUF_GSV    80
/*
 $GPRMC,hhmmss.sss,V,ddmm.mmmm,N,dddmm.mmmm,E,k.kkk,x.xx,ddmmyy,,,N*sum<CR><LF>
    ex. $GPRMC,060309.00,A,4344.77571,N,14223.38879,
            E,0.03,210.32,190808,06.2,W,D*51
    # of data (ex.) = 84
*/
#define     SIZE_BUF_RMC    96
/*
 $GPVTG,xx.xx,T,,M,x.xx,N,x.xx,K,A*sum<CR><LF>
    ex. $GPVTG,210.32,T,204.30,M,0.03,N,0.06,K,D*3F
    # of data (ex.) = 43
*/
#define     SIZE_BUF_VTG    64
/*
 $GPZDA,hhmmss.sss,dd,mmm,yyyy,hh,mm*sum<CR><LF>
    ex. $GPZDA,060307.00,19,08,2008,13,26*6E
    # of data (ex.) = 36
*/
#define     SIZE_BUF_ZDA    48
/*
 $GPGLL,ddmm.mmmmmm,N,dddmm.mmmmmm,E,hhmmss.sss,V,D*sum<CR><LF>
    ex. $GPGLL,4344.77956,N,14223.38863,E,060305.00,A,D*61
    # of data (ex.) = 52
*/
#define     SIZE_BUF_GLL    64

#define     ERR             0xff
