/*
 * mbed Library / Frequency Counter / Reciprocal type only
 *      Frequency Counter program
 *      Only for Nucleo-F401RE,-F411RE,-F446RE
 *
 * Copyright (c) 2014,'15,'16,'20 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *      Started:    October   18th, 2014
 *      Revised:    January   19th, 2020
 *
 */

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "fc_recipro.h"

//  Definition -----------------------------------------------------------------
#if (MBED_MAJOR_VERSION == 2)
#   define WAIT(x) wait_ms(x)
#elif (MBED_MAJOR_VERSION == 5)
#   define WAIT(x) ThisThread::sleep_for(x)
#endif

#define EXAMPLE_NUMBER      1   // select 0 to 2

#if EXAMPLE_NUMBER   == 0
#   define EXAMPLE0
#elif EXAMPLE_NUMBER == 1
#   define EXAMPLE1
#elif EXAMPLE_NUMBER == 2
#   define EXAMPLE2
#else
#   error " Please set 0 to 2 number for EXAMPLE_NUMBER!!"
#endif


using namespace Frequency_counter;

//  Object ---------------------------------------------------------------------
DigitalOut  led1(LED1);
Serial      pc(USBTX, USBRX);
Timer       t;
FRQ_CUNTR   fc;     //Frequency Counter

//  RAM ------------------------------------------------------------------------
Recipro_result_TypeDef freq;
Recipro_status_TypeDef status;
int64_t raw_buf[4];

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
#ifdef EXAMPLE0
int main()
{
    //pc.printf("\r\nStart Frequency Counter\r\n");
    fc.recipro_start_measurement();
    while(true) {
        t.reset();
        t.start();
        if (fc.recipro_check_status(&status) == true) {
            fc.recipro_get_result(&freq);
            pc.printf("freq = %.3f [Hz], time(rise_fall) = %.6f [mS]\r\n",
                      freq.freq_rise2rise, freq.time_us_rise2fall);
        } else {
            pc.printf("------   data is NOT ready -------\r\n");
        }
        uint32_t pass = t.read_ms();
        if (pass < 990) {
            WAIT(1000 - pass);
        }
    }
}
#endif

#ifdef EXAMPLE1
int main()
{
    pc.printf("\r\nStart Frequency Counter\r\n");
    fc.recipro_start_measurement();
    while(true) {
        t.reset();
        t.start();
        if (fc.recipro_check_status(&status) == true) {
            fc.recipro_get_result(&freq);
            pc.printf("freq/rise_rise[Hz]= %f, ",
                      freq.freq_rise2rise);
            pc.printf("/fall_fall= %f, ",
                      freq.freq_fall2fall);
            pc.printf("time/rise_fall[mS]= %f, ",
                      freq.time_us_rise2fall);
            pc.printf("/fall_rise= %f, ",
                      freq.time_us_fall2rise);
        } else {
            pc.printf("------   data is NOT ready -------,,,,");
        }
        pc.printf("Rise= %d, Fall= %d, ",
                  status.rise_cnt, status.fall_cnt);
        pc.printf("Input= %d, Passed-time[sec]= %.0f\r\n",
                  status.input_level, status.passed_time);
        uint32_t pass = t.read_ms();
        if (pass < 990) {
            WAIT(1000 - pass);
        }
    }
}
#endif

#ifdef EXAMPLE2
int main()
{
    pc.printf("\r\nStart Frequency Counter\r\n");
    fc.recipro_start_measurement();
    while(true) {
        t.reset();
        t.start();
        if (fc.recipro_check_status(&status) == true) {
            fc.recipro_get_result(&freq);
            pc.printf("freq/rise_rise[Hz]= %f, ",
                      freq.freq_rise2rise);
            pc.printf("/fall_fall= %f, ",
                      freq.freq_fall2fall);
            pc.printf("time/rise_fall[mS]= %f, ",
                      freq.time_us_rise2fall);
            pc.printf("/fall_rise= %f, ",
                      freq.time_us_fall2rise);
        } else {
            pc.printf("------   data is NOT ready -------,,,,");
        }
        pc.printf("Rise= %d, Fall= %d, ",
                  status.rise_cnt, status.fall_cnt);
        pc.printf("Input= %d, Passed-time[sec]= %.0f\r\n",
                  status.input_level, status.passed_time);
        fc.recipro_get_raw_data(raw_buf);
        pc.printf("Rise raw data0= %.0f, Rise raw data1= %.0f, ",
                  (float)raw_buf[0], (float)raw_buf[1]);
        pc.printf("Fall raw data0= %.0f, Fall raw data1= %.0f\r\n",
                  (float)raw_buf[2], (float)raw_buf[3]);
        float base_clock = (float)(SystemCoreClock / 2);
        float resolution = 1.0f / (float)base_clock * 1.0e9; // nano seconds(nS)
        pc.printf("TIMER2 base clock = %.0f [Hz], resolution= %.3f [nS]\r\n",
                  base_clock, resolution);
        uint32_t pass = t.read_ms();
        if (pass < 990) {
            WAIT(1000 - pass);
        }
    }
}
#endif
