/*
 * mbed Application program / HARDWARE TEST mode program
 *
 * Copyright (c) 2016,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    Novemeber  8th, 2016
 *      Revised:    December  12th, 2019
 */

//  Include --------------------------------------------------------------------

//  Definition -----------------------------------------------------------------
#define GETC(x)             pc.getc(x)
#define PUTC(x)             pc.putc(x)
#define PRINTF(...)         pc.printf(__VA_ARGS__)
#define READABLE(x)         pc.readable(x)

//  Object ---------------------------------------------------------------------
extern Serial      pc;
extern Serial      gps;
extern DigitalIn   gps_rx;
extern Ticker      irq_action;
extern DigitalOut  led_R_gps1pps;
extern DigitalOut  led_G_temp_ok;
extern DigitalOut  led_B_recipro;
extern DigitalOut  led_W_prescaler;
extern DigitalOut  led_R_rotary;
extern DigitalOut  led_G_rotary;
extern DigitalOut  led_B_rotary;
extern TextLCD     lcd;

//  RAM ------------------------------------------------------------------------
char linebuf[64];
int buf_size = sizeof(linebuf);

//  Function prototypes --------------------------------------------------------
extern int    iGPS_getc(void);
extern double read_temperature(uint8_t n);
extern void   temp_control(void const *args);
extern void   select_input_div_1or10or20(uint8_t mode);

void msg_hlp(void);
void put_rn(void);
void put_r(void);
void put_lin(void);
void put_spc(uint8_t n);
int  xatoi(char **str, int32_t *res);
void get_line(char *buff, int len);

//  ROM / Constant data --------------------------------------------------------
char *const test_msg0 = "F746ZG Frequency Counter Hardware Test on mbed";
char *const test_msg1 = " system, created on UTC: " __DATE__"(" __TIME__")";

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
void hardware_test(void)
{
    char *ptr;
    char c;
    uint32_t n;

    put_rn();
    put_rn();
    msg_hlp();
    for (;;) {
        put_r();
        PUTC('>');
        ptr = linebuf;
        get_line(ptr, sizeof(linebuf));
        switch (*ptr++) {
            //------------------------------------------------------------------
            //  LED
            //------------------------------------------------------------------
            case 'l' :
                put_r();
                PRINTF("If you want to stop, please het any key.");
                put_rn();
                while (true){
                    led_R_gps1pps = 1;
                    ThisThread::sleep_for(400);
                    led_R_gps1pps = 0;
                    led_G_temp_ok = 1;
                    ThisThread::sleep_for(400);
                    led_G_temp_ok = 0;  
                    led_B_recipro = 1;
                    ThisThread::sleep_for(400);
                    led_B_recipro = 0;
                    led_W_prescaler = 1;
                    ThisThread::sleep_for(400);
                    led_W_prescaler = 0;
                    led_R_rotary = 1;
                    ThisThread::sleep_for(400);
                    led_R_rotary = 0;
                    led_G_rotary = 1;
                    ThisThread::sleep_for(400);
                    led_G_rotary = 0;
                    led_B_rotary = 1;
                    ThisThread::sleep_for(400);
                    led_B_rotary = 0;
                    if (READABLE()){ break;}
                }
                c = GETC(); // read as dummy
                put_r();
                break;
            //------------------------------------------------------------------
            //  LCD Display
            //------------------------------------------------------------------
            case 'd' :
                put_r();
                lcd.locate(0, 0);
                for(char i = 'z';'*' < i; i--){
                    lcd.putc(i);
                }
                lcd.locate(0, 0);
                ThisThread::sleep_for(2000);
                for(char i = '.';'~' > i; i++){
                    lcd.putc(i);
                }
                PRINTF("Please adjust Contrast Volue.");
                put_rn();
                PRINTF("Hit any key to clear screan.");
                put_rn();
                while (READABLE()){;}
                c = GETC(); // read as dummy
                lcd.locate(0, 0);
                for (uint8_t x =0 ;100 > x; x++){
                    lcd.putc(' ');
                }
                break;
            //------------------------------------------------------------------
            //  Frequency
            //------------------------------------------------------------------
            case 'f' :
                put_r();
                select_input_div_1or10or20(0);
                PRINTF("50MHz Clock for Timer2:");
                PRINTF("   Input clock for Timer8+4:");
                put_rn();
                while (true){
                    n = fc.read_base_clock_frequency(1.0f);
                    PRINTF("  %u                  ", n);
                    n = fc.read_input_frequency(1.0f);
                    PRINTF("%u", n);
                    put_rn();
                    if (READABLE()){ break;}
                }
                c = GETC(); // read as dummy
                break;
            //------------------------------------------------------------------
            //  Input select
            //------------------------------------------------------------------
            case 'i' :
                put_r();
                select_input_div_1or10or20(0);
                PRINTF("Start BNC connecter input (none-prescaler)");
                put_rn();
                PRINTF("Input freq. (data is not accurate enough");
                put_rn();
                PRINTF("Hit any key to go next input");
                put_rn();
                while (true){
                    n = fc.read_input_frequency(1.0f);
                    PRINTF("f = %u [Hz]", n);
                    put_rn();
                    if (READABLE()){ break;}
                }
                c = GETC(); // read as dummy
                select_input_div_1or10or20(1);
                PRINTF("Start SMA connecter input (prescaler 1/10)");
                put_rn();
                PRINTF("Hit any key to go next input");
                put_rn();
                while (true){
                    n = fc.read_input_frequency(1.0f);
                    PRINTF("f = %u [Hz] x 10 = (your expected freq.)", n);
                    put_rn();
                    if (READABLE()){ break;}
                }                
                c = GETC(); // read as dummy
                select_input_div_1or10or20(2);
                PRINTF("Start SMA connecter input (prescaler 1/20)");
                put_rn();
                PRINTF("Hit any key to go next input");
                put_rn();
                while (true){
                    n = fc.read_input_frequency(1.0f);
                    PRINTF("f = %u [Hz] x 20 = (your expected freq.)", n);
                    put_rn();
                    if (READABLE()){ break;}
                }                
                c = GETC(); // read as dummy
                break;
            //------------------------------------------------------------------
            //  GPS signal
            //------------------------------------------------------------------
            case 'g' :
                put_r();
                PRINTF("Start GPS checking.");
                put_rn();
                PRINTF("If you want to stop, please het any key");
                put_rn();
                // Wait long interval (every 1sec)
                for (uint32_t i = 0; i < 100000; i++){
                    if (gps_rx == 0){
                        i = 0;
                    }
                }
                //  Clear PD_2 GPS RX line errors(over run)
                CLEAR_PD_2_RX_LINE();
                n = 0;
                while (true){
                    pc.putc(gps.getc());
                    led_R_gps1pps = !led_R_gps1pps;
                    if (!(++n % 100)){
                        led_R_gps1pps = !led_R_gps1pps;
                    }
                    if (READABLE()){ break;}
                }
                c = GETC(); // read as dummy
                led_R_gps1pps = 0;
                put_rn();
                PRINTF("Finish GPS part.\r\n");
                break;
            //------------------------------------------------------------------
            //  Temperature
            //------------------------------------------------------------------
            case 't' :
                put_r();
                read_temperature(0);
                while (true){
                    PRINTF("Temperature: %+6.3f", read_temperature(1));
                    put_rn();
                    if (READABLE()){ break;}
                    ThisThread::sleep_for(1000);
                }
                c = GETC(); // read as dummy
                break;
            //------------------------------------------------------------------
            //  Special command defined by you
            //------------------------------------------------------------------
            case 'x' :
                while (true){
                    put_rn();
                    if (READABLE()){ break;}
                    ThisThread::sleep_for(1000);
                }
                c = GETC(); // read as dummy
                break;
            //------------------------------------------------------------------
            //  Oven Temperature Control
            //------------------------------------------------------------------
            case 'o' :
                put_r();
                PRINTF("Please check Temp. sensor ('t' comand )");
                PRINTF(" before enter this test.");
                put_rn();
                PRINTF("Are you sure? Yes, the enter 'y'.");
                put_rn();
                c = GETC();
                if (c != 'y'){ break;}
                PRINTF("If you want to exit, please enter ALT+B.");
                put_rn();
                temp_control(NULL);
                break;
            //------------------------------------------------------------------
            //  help
            //------------------------------------------------------------------
            case '?' :
                put_r();
                msg_hlp();
                break;
            //------------------------------------------------------------------
            //  no support
            //------------------------------------------------------------------
            default:
                put_r();
                PUTC('?');
                put_rn();
                break;
        }
    }
}

void msg_hlp (void)
{
    PRINTF(test_msg0);
    PRINTF(test_msg1);
    PRINTF(" [Help:'?']");
    put_rn();
    put_rn();
    PRINTF("l - ChecK LED's");
    put_rn();
    PRINTF("d - Show display (on LCD)");
    put_rn();
    PRINTF("f - Check frequency Base:50MHz & Unknown Freq.");
    put_rn();
    PRINTF("i - Check Input select function");
    put_rn();
    PRINTF("g - Check GPS signal");
    put_rn();
    PRINTF("t - Check Temperature (I2C temp sensor)");
    put_rn();
    PRINTF("o - Run Oven Temperature Control");
    put_rn();
    PRINTF("return from 'o' mode, enter ALT+B then the system restart");
    put_rn();
}

//  Put \r\n
void put_rn ( void )
{
    PUTC('\r');
    PUTC('\n');
}

//  Put \r
void put_r ( void )
{
    PUTC('\r');
}

// Put ", "
void put_lin ( void )
{
    PRINTF(", ");
}

// Put space n
void put_spc( uint8_t n)
{
    for(; n > 0; n--) {
        PUTC(' ');
    }
}

//  Change string -> integer
//int xatoi (char **str, unsigned long *res){
int xatoi (char **str, int32_t *res)
{
    unsigned long val;
    unsigned char c, radix, s = 0;

    while ((c = **str) == ' ') (*str)++;
    if (c == '-') {
        s = 1;
        c = *(++(*str));
    }
    if (c == '0') {
        c = *(++(*str));
        if (c <= ' ') {
            *res = 0;
            return 1;
        }
        if (c == 'x') {
            radix = 16;
            c = *(++(*str));
        } else {
            if (c == 'b') {
                radix = 2;
                c = *(++(*str));
            } else {
                if ((c >= '0')&&(c <= '9')) {
                    radix = 8;
                }   else {
                    return 0;
                }
            }
        }
    } else {
        if ((c < '1')||(c > '9')) {
            return 0;
        }
        radix = 10;
    }
    val = 0;
    while (c > ' ') {
        if (c >= 'a') c -= 0x20;
        c -= '0';
        if (c >= 17) {
            c -= 7;
            if (c <= 9) return 0;
        }
        if (c >= radix) return 0;
        val = val * radix + c;
        c = *(++(*str));
    }
    if (s) val = -val;
    *res = val;
    return 1;
}

//  Get key input data
void get_line (char *buff, int len)
{
    char c;
    int idx = 0;

    for (;;) {
        c = GETC();
        if (c == '\r') {
            buff[idx++] = c;
            break;
        }
        if ((c == '\b') && idx) {
            idx--;
            PUTC(c);
            PUTC(' ');
            PUTC(c);
        }
        if (((uint8_t)c >= ' ') && (idx < len - 1)) {
            buff[idx++] = c;
            PUTC(c);
        }
    }
    buff[idx] = 0;
    PUTC('\n');
}
