/*
 * mbed Application program / User Interface subroutines
 *
 * Copyright (c) 2016,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    September 28th, 2016
 *      Revised:    December  22nd, 2019
 */

//  Definition -----------------------------------------------------------------
typedef struct{
    double m_frq;           // measured freq. data 1sec interval (Raw data)
    double m_frq_10;        // same as avove / avarage 10sec
    double m_frq_100;       // same as avove / avarage 100sec   
    double m_frq_1000;      // same as avove / avarage 1000sec
    double m_frq_comp;      // same as avove / compensated data
    double m_frq_recipro;   // masured freq. by reciprocal way
    double b_1pps_lng;      // base clock by 1PPS (avarage data)
    uint32_t b_1pps_new;    // same as avobe / newest raw data
    double box_tmp;         // temperature of temperature oven 
    uint8_t  recipro_of;    // reciprocal overflow (higher freq)
    uint8_t  temp_is_okay;  // oven temperature is inside of range
    uint32_t gps_1pps_ave;  // GPS 1PPS # of avarage
    uint32_t ready_1pps;    // GPS 1PPS is available (none-zero)
}dispDef;
    
//  Function prototypes --------------------------------------------------------
void dispay_LCD_and_UART(dispDef *dt);
void display_clear_all(void);
void disp_first_msg(void);
void disp_wait_gps(void);
void select_input_div_1or10or20(uint8_t div);
