/*
    FreeRTOS V6.0.3 - Copyright (C) 2010 Real Time Engineers Ltd.

    ***************************************************************************
    *                                                                         *
    * If you are:                                                             *
    *                                                                         *
    *    + New to FreeRTOS,                                                   *
    *    + Wanting to learn FreeRTOS or multitasking in general quickly       *
    *    + Looking for basic training,                                        *
    *    + Wanting to improve your FreeRTOS skills and productivity           *
    *                                                                         *
    * then take a look at the FreeRTOS eBook                                  *
    *                                                                         *
    *        "Using the FreeRTOS Real Time Kernel - a Practical Guide"        *
    *                  http://www.FreeRTOS.org/Documentation                  *
    *                                                                         *
    * A pdf reference manual is also available.  Both are usually delivered   *
    * to your inbox within 20 minutes to two hours when purchased between 8am *
    * and 8pm GMT (although please allow up to 24 hours in case of            *
    * exceptional circumstances).  Thank you for your support!                *
    *                                                                         *
    ***************************************************************************

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation AND MODIFIED BY the FreeRTOS exception.
    ***NOTE*** The exception to the GPL is included to allow you to distribute
    a combined work that includes FreeRTOS without being obliged to provide the
    source code for proprietary components outside of the FreeRTOS kernel.
    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details. You should have received a copy of the GNU General Public 
    License and the FreeRTOS license exception along with FreeRTOS; if not it 
    can be viewed here: http://www.freertos.org/a00114.html and also obtained 
    by writing to Richard Barry, contact details for whom are available on the
    FreeRTOS WEB site.

    1 tab == 4 spaces!

    http://www.FreeRTOS.org - Documentation, latest information, license and
    contact details.

    http://www.SafeRTOS.com - A version that is certified for use in safety
    critical systems.

    http://www.OpenRTOS.com - Commercial support, development, porting,
    licensing and training services.
*/

/*
 *  Modified for mbed & Xpresso NXP LPC1768 board
 *  By Kenji Arai / JH1PJL on March 9th,2010
 *      August 1st,2010
 */

#ifndef FREERTOS_CONFIG_H
#define FREERTOS_CONFIG_H

#include "LPC17xx.h"

#define portREMOVE_STATIC_QUALIFIER

// Modified by  Kenji Arai / JH1PJL, August 28th,2010
/*-----------------------------------------------------------
 * Board Selection
 *-----------------------------------------------------------*/
#define USE_XPRESSO 0
#define USE_MBED    1

// Modified by  Kenji Arai / JH1PJL, September 10th,2010
/*-----------------------------------------------------------
 * ADC mode selection
 *-----------------------------------------------------------*/
#define CH_GSEN_ONLY 1

// Modified by  Kenji Arai / JH1PJL, August 22nd,2010
/*-----------------------------------------------------------
 * AHB Memory usage
 *-----------------------------------------------------------*/
#define USE_AHB_RAM 1

// Modified by  Kenji Arai / JH1PJL, September 18th,2010
/*-----------------------------------------------------------
 * Monitor interface
 *-----------------------------------------------------------*/
#define MON_VIA_USB    0
#define MON_VIA_UART 1

/*-----------------------------------------------------------
 * Application specific definitions.
 *
 * These definitions should be adjusted for your particular hardware and
 * application requirements.
 *
 * THESE PARAMETERS ARE DESCRIBED WITHIN THE 'CONFIGURATION' SECTION OF THE
 * FreeRTOS API DOCUMENTATION AVAILABLE ON THE FreeRTOS.org WEB SITE.
 *----------------------------------------------------------*/

#define configUSE_PREEMPTION        1
#define configUSE_IDLE_HOOK            0
#define configMAX_PRIORITIES        ( ( unsigned portBASE_TYPE ) 5 )
#define configUSE_TICK_HOOK            1
// Modified by  Kenji Arai / JH1PJL, May 2nd,2010
#define configCPU_CLOCK_HZ            ( ( unsigned long ) 99000000 )
//#define configCPU_CLOCK_HZ        ( ( unsigned long ) 100000000 )
#define configTICK_RATE_HZ            ( ( portTickType ) 1000 )
#define configMINIMAL_STACK_SIZE    ( ( unsigned short ) 64 )
// Modified by  Kenji Arai / JH1PJL, August 13th,2010
#define configMIN_STACK_SIZE        ( ( unsigned short ) 80 )
#define configMID_STACK_SIZE        ( ( unsigned short ) 120 )
#define configMAX_STACK_SIZE        ( ( unsigned short ) 180 )

// Modified by  Kenji Arai / JH1PJL, May 8th,2010
//#define configTOTAL_HEAP_SIZE        ( ( size_t ) ( 17 * 1024 ) )
//    back to original August 18th, 2010
//#define configTOTAL_HEAP_SIZE        ( ( size_t ) ( 19 * 1024 ) )
//    more bigger August 18th, 2010
#define configTOTAL_HEAP_SIZE        ( ( size_t ) ( 22 * 1024 ) )
#define configMAX_TASK_NAME_LEN        ( 12 )
#define configUSE_TRACE_FACILITY    1
#define configUSE_16_BIT_TICKS        0
#define configIDLE_SHOULD_YIELD        0
#define configUSE_CO_ROUTINES         0
#define configUSE_MUTEXES            1

#define configMAX_CO_ROUTINE_PRIORITIES ( 2 )

#define configUSE_COUNTING_SEMAPHORES     0
#define configUSE_ALTERNATIVE_API         0
#define configCHECK_FOR_STACK_OVERFLOW    2
#define configUSE_RECURSIVE_MUTEXES        1
#define configQUEUE_REGISTRY_SIZE        10
#define configGENERATE_RUN_TIME_STATS    1

/* Set the following definitions to 1 to include the API function, or zero
to exclude the API function. */

#define INCLUDE_vTaskPrioritySet            1
#define INCLUDE_uxTaskPriorityGet            1
#define INCLUDE_vTaskDelete                    1
#define INCLUDE_vTaskCleanUpResources        0
#define INCLUDE_vTaskSuspend                1
#define INCLUDE_vTaskDelayUntil                1
#define INCLUDE_vTaskDelay                    1
#define INCLUDE_uxTaskGetStackHighWaterMark    1

/*-----------------------------------------------------------
 * Ethernet configuration.
 *-----------------------------------------------------------*/

/* MAC address configuration. */
#define configMAC_ADDR0    0x00
#define configMAC_ADDR1    0x12
#define configMAC_ADDR2    0x13
#define configMAC_ADDR3    0x10
#define configMAC_ADDR4    0x15
#define configMAC_ADDR5    0x11

/* IP address configuration. */
#define configIP_ADDR0        192
#define configIP_ADDR1        168
// Modified by  Kenji Arai / JH1PJL, March 9th,2010
//#define configIP_ADDR2    0
#define configIP_ADDR2        1
//#define configIP_ADDR3    201
#define configIP_ADDR3        22

/* Netmask configuration. */
#define configNET_MASK0        255
#define configNET_MASK1        255
#define configNET_MASK2        255
#define configNET_MASK3        0

/* Use the system definition, if there is one */
#ifdef __NVIC_PRIO_BITS
    #define configPRIO_BITS       __NVIC_PRIO_BITS
#else
    #define configPRIO_BITS       5        /* 32 priority levels */
#endif

/* The lowest priority. */
#define configKERNEL_INTERRUPT_PRIORITY     ( 31 << (8 - configPRIO_BITS) )
/* Priority 5, or 160 as only the top three bits are implemented. */
#define configMAX_SYSCALL_INTERRUPT_PRIORITY     ( 5 << (8 - configPRIO_BITS) )

/* Priorities passed to NVIC_SetPriority() do not require shifting as the
function does the shifting itself.  Note these priorities need to be equal to
or lower than configMAX_SYSCALL_INTERRUPT_PRIORITY - therefore the numeric
value needs to be equal to or greater than 5 (on the Cortex M3 the lower the
numeric value the higher the interrupt priority). */
#define configEMAC_INTERRUPT_PRIORITY        5
#define configUSB_INTERRUPT_PRIORITY        6


/*-----------------------------------------------------------
 * Macros required to setup the timer for the run time status.
 *-----------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif
extern void vConfigureTimerForRunTimeStats( void );
#ifdef __cplusplus
}
#endif
//extern void vConfigureTimerForRunTimeStats( void );
#define portCONFIGURE_TIMER_FOR_RUN_TIME_STATS() vConfigureTimerForRunTimeStats()
// Modified by K.Arai April 11th, 2010
#define portGET_RUN_TIME_COUNTER_VALUE() LPC_TIM0->TC


#endif /* FREERTOS_CONFIG_H */
