;//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
;
; This is a program for FreeRTOS on LPC1768 mbed IDE
;
;    C source file:             port_asm.c
;    Compiled on:             GCC: (Sourcery G++ Lite 2010q1-188) 4.4.1
;    Hand modification by:    Kenji Arai / JH1PJL
;                        http://www.page.sannet.ne.jp/kenjia/index.html
;
;    Started on:                October 31st, 2010
;    updated on:                October 31st, 2010
;
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
;    .syntax unified
;    .cpu cortex-m3
;    .fpu softvfp
;    .eabi_attribute 20, 1
;    .eabi_attribute 21, 1
;    .eabi_attribute 23, 3
;    .eabi_attribute 24, 1
;    .eabi_attribute 25, 1
;    .eabi_attribute 26, 1
;    .eabi_attribute 30, 6
;    .eabi_attribute 18, 4

    EXTERN  pxCurrentTCB
    EXTERN  uxCriticalNesting
    EXTERN  vTaskSwitchContext
    EXTERN  vTaskIncrementTick
    EXTERN  prvCopyDataToQueue
    EXTERN  xTaskRemoveFromEventList
    EXTERN  prvCopyDataFromQueue
    EXTERN  prvIdleTask
    EXTERN  xTaskGenericCreate
    EXTERN  xSchedulerRunning
    EXTERN  xTickCount
    EXTERN  vConfigureTimerForRunTimeStats  
    EXTERN  xPortStartScheduler
    EXTERN  vPortEndScheduler
    
    CODE16
    PRESERVE8
    AREA    Port, CODE, READONLY
;//////////////////////////////////////////////////////
;    .thumb
    THUMB
;    .file    "port_asm.c"
;    .text
;    .align    2
    ALIGN    2
    GLOBAL  Reset_Handler
    THUMB
Reset_Handler
    push    {r7, lr}
    pop    {r7, pc}

;///////////////////////////////////////////////////////    
    ALIGN   2    
;    .global    vPortSVCHandler
    GLOBAL    vPortSVCHandler
;    .thumb
    THUMB
;    .thumb_func
;    .type    vPortSVCHandler, %function
;vPortSVCHandler:
vPortSVCHandler
;    @ Naked Function: prologue and epilogue provided by programmer.
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
;@ 199 "port_asm.c" 1
    ldr        r3, pxCurrentTCBConst2        
    ldr        r1, [r3]                    
    ldr        r0, [r1]                    
    ldmia    r0!, {r4-r11}                
    msr        psp, r0                        
    mov        r0, #0                         
    msr        basepri, r0                    
    orr        r14, #0xd                    
    bx        r14                            
                                    
;    .align    2
    ALIGN    2                        
;pxCurrentTCBConst2: .word pxCurrentTCB                
pxCurrentTCBConst2 DCD pxCurrentTCB

;@ 0 "" 2
;    .thumb
    THUMB
;    .size    vPortSVCHandler, .-vPortSVCHandler
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    vPortStartFirstTask
    GLOBAL    vPortStartFirstTask
;    .thumb
    THUMB
;    .thumb_func
;    .type    vPortStartFirstTask, %function
;vPortStartFirstTask:
vPortStartFirstTask
;    @ Naked Function: prologue and epilogue provided by programmer.
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
;@ 218 "port_asm.c" 1
    ldr        r0, =0xE000ED08     
    ldr        r0, [r0]             
    ldr        r0, [r0]             
    msr        msp, r0            
    svc        0                    

;@ 0 "" 2
;    .thumb
    THUMB
;    .size    vPortStartFirstTask, .-vPortStartFirstTask
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    vPortEnterCritical
    GLOBAL    vPortEnterCritical
;    .thumb
    THUMB
;    .thumb_func
;    .type    vPortEnterCritical, %function
;vPortEnterCritical:
vPortEnterCritical
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
;    @ link register save eliminated.
    push       {r7}
    add        r7, sp, #0
;@ 270 "port_asm.c" 1
    mov        r0, #40                                
    msr        basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    movw    r3, #:lower16:uxCriticalNesting
    movt        r3, #:upper16:uxCriticalNesting
    ldr        r3, [r3, #0]
    add        r2, r3, #1
    movw    r3, #:lower16:uxCriticalNesting
    movt        r3, #:upper16:uxCriticalNesting
    str        r2, [r3, #0]
    mov        sp, r7
    pop        {r7}
    bx        lr
;    .size    vPortEnterCritical, .-vPortEnterCritical
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    vPortExitCritical
    GLOBAL    vPortExitCritical
;    .thumb
    THUMB
;    .thumb_func
;    .type    vPortExitCritical, %function
;vPortExitCritical:
vPortExitCritical
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
;    @ link register save eliminated.
    push        {r7}
    add        r7, sp, #0
    movw    r3, #:lower16:uxCriticalNesting
    movt        r3, #:upper16:uxCriticalNesting
    ldr        r3, [r3, #0]
    add        r2, r3, #-1
    movw    r3, #:lower16:uxCriticalNesting
    movt        r3, #:upper16:uxCriticalNesting
    str        r2, [r3, #0]
    movw    r3, #:lower16:uxCriticalNesting
    movt        r3, #:upper16:uxCriticalNesting
    ldr        r3, [r3, #0]
    cmp        r3, #0
;    bne    .L9
    bne        Jmp0
;@ 280 "port_asm.c" 1
    mov        r0, #0                    
    msr        basepri, r0                

;@ 0 "" 2
;    .thumb
    THUMB
;.L9:
Jmp0
    mov        sp, r7
    pop        {r7}
    bx        lr
;    .size    vPortExitCritical, .-vPortExitCritical
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    xPortPendSVHandler
    GLOBAL    xPortPendSVHandler
;    .thumb
    THUMB
;    .thumb_func
;    .type    xPortPendSVHandler, %function
;xPortPendSVHandler:
xPortPendSVHandler
;    @ Naked Function: prologue and epilogue provided by programmer.
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
;@ 289 "port_asm.c" 1
    mrs        r0, psp                            
                                        
    ldr        r3, pxCurrentTCBConst            
    ldr        r2, [r3]                        
                                        
    stmdb    r0!, {r4-r11}                    
    str        r0, [r2]                        
                                        
    stmdb    sp!, {r3, r14}                
    mov        r0, #40                            
    msr        basepri, r0
;   error      " port_asm_mbed.s.s.LPC1768.o(Port) contains invalid call from '~PRES8 (The user did not require code to preserve 8-byte aligment of 8-byte data objects)' function to 'REQ8 (Code was permitted to depend on the 8-byte aligment of 8-byte data items)' function vTaskSwitchContext. (EL6238E)                     
    bl        vTaskSwitchContext
                    
    mov        r0, #0                            
    msr        basepri, r0                        
    ldmia    sp!, {r3, r14}                
                                        
    ldr        r1, [r3]                        
    ldr        r0, [r1]                        
    ldmia    r0!, {r4-r11}                    
    msr        psp, r0                            
    bx        r14                                
                                        
;    .align    2
    ALIGN    2                            
;pxCurrentTCBConst: .word pxCurrentTCB
pxCurrentTCBConst DCD pxCurrentTCB    

;@ 0 "" 2
;    .thumb
    THUMB
;    .size    xPortPendSVHandler, .-xPortPendSVHandler
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    xPortSysTickHandler
    GLOBAL    xPortSysTickHandler
;    .thumb
    THUMB
;    .thumb_func
;    .type    xPortSysTickHandler, %function
;xPortSysTickHandler:
xPortSysTickHandler
;    @ args = 0, pretend = 0, frame = 8
;    @ frame_needed = 1, uses_anonymous_args = 0
    push       {r7, lr}
    sub        sp, sp, #8
    add        r7, sp, #0
;    movw       r3, #:lower16:-536810236
;    movt       r3, #:upper16:-536810236
    movw       r3, #0xED04
    movt       r3, #0xE000
;    movw       r3, #:LDW:(-536810236)
;    movt       r3, #:HDW:(-536810236)
;    mov32      r3, -536810236
;    mov        r2, #268435456
    str        r2, [r3, #0]
    mov        r3, #0
    str        r3, [r7, #4]
;@ 329 "port_asm.c" 1
    mov        r0, #40                                
    msr        basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    bl    vTaskIncrementTick
;@ 333 "port_asm.c" 1
    mov        r0, #0                    
    msr        basepri, r0                

;@ 0 "" 2
;    .thumb
    THUMB
    add    r7, r7, #8
    mov    sp, r7
    pop    {r7, pc}
;    .size    xPortSysTickHandler, .-xPortSysTickHandler
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    xQueueGenericSendFromISR
    GLOBAL    xQueueGenericSendFromISR
;    .thumb
    THUMB
;    .thumb_func
;    .type    xQueueGenericSendFromISR, %function
;xQueueGenericSendFromISR:
xQueueGenericSendFromISR
;    @ args = 0, pretend = 0, frame = 24
;    @ frame_needed = 1, uses_anonymous_args = 0
    push    {r7, lr}
    sub    sp, sp, #24
    add    r7, sp, #0
    str    r0, [r7, #12]
    str    r1, [r7, #8]
    str    r2, [r7, #4]
    str    r3, [r7, #0]
    mov    r3, #0
    str    r3, [r7, #20]
;@ 399 "port_asm.c" 1
    mov r0, #40                                
    msr basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    ldr    r3, [r7, #12]
    ldr    r2, [r3, #56]
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #60]
    cmp    r2, r3
;    bcs    .L15
    bcs    Jmp5
    ldr    r0, [r7, #12]
    ldr    r1, [r7, #8]
    ldr    r2, [r7, #0]
    bl    prvCopyDataToQueue
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #72]
    cmp    r3, #-1
;    bne    .L16
    bne    Jmp1
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #36]
    cmp    r3, #0
;    beq    .L21
    beq    Jmp2
    ldr    r3, [r7, #12]
    add    r3, r3, #36
    mov    r0, r3
    bl    xTaskRemoveFromEventList
    mov    r3, r0
    cmp    r3, #0
;    beq    .L22
    beq    Jmp3
    ldr    r3, [r7, #4]
    mov    r2, #1
    str    r2, [r3, #0]
;    b    .L18
    b    Jmp4
;.L16:
Jmp1
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #72]
    add    r2, r3, #1
    ldr    r3, [r7, #12]
    str    r2, [r3, #72]
;    b    .L18
    b    Jmp4
;.L21:
Jmp2
    nop
;    b    .L18
    b    Jmp4
;.L22:
Jmp3
    nop
;.L18:
Jmp4
    mov    r3, #1
    str    r3, [r7, #16]
;    b    .L19
    b    Jmp6
;.L15:
Jmp5
    mov    r3, #0
    str    r3, [r7, #16]
;.L19:
Jmp6
;@ 436 "port_asm.c" 1
    mov r0, #0                    
    msr basepri, r0                

;@ 0 "" 2
;    .thumb
    THUMB
    ldr    r3, [r7, #16]
    mov    r0, r3
    add    r7, r7, #24
    mov    sp, r7
    pop    {r7, pc}
;    .size    xQueueGenericSendFromISR, .-xQueueGenericSendFromISR
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    xQueueReceiveFromISR
    GLOBAL    xQueueReceiveFromISR
;    .thumb
    THUMB
;    .thumb_func
;    .type    xQueueReceiveFromISR, %function
;xQueueReceiveFromISR:
xQueueReceiveFromISR
;    @ args = 0, pretend = 0, frame = 24
;    @ frame_needed = 1, uses_anonymous_args = 0
    push    {r7, lr}
    sub    sp, sp, #24
    add    r7, sp, #0
    str    r0, [r7, #12]
    str    r1, [r7, #8]
    str    r2, [r7, #4]
    mov    r3, #0
    str    r3, [r7, #20]
;@ 449 "port_asm.c" 1
    mov r0, #40                                
    msr basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #56]
    cmp    r3, #0
;    beq    .L24
    beq    Jmp11
    ldr    r0, [r7, #12]
    ldr    r1, [r7, #8]
    bl    prvCopyDataFromQueue
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #56]
    add    r2, r3, #-1
    ldr    r3, [r7, #12]
    str    r2, [r3, #56]
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #68]
    cmp    r3, #-1
;    bne    .L25
    bne    Jmp7
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #16]
    cmp    r3, #0
;    beq    .L30
    beq    Jmp8
    ldr    r3, [r7, #12]
    add    r3, r3, #16
    mov    r0, r3
    bl    xTaskRemoveFromEventList
    mov    r3, r0
    cmp    r3, #0
;    beq    .L31
    beq    Jmp9
    ldr    r3, [r7, #4]
    mov    r2, #1
    str    r2, [r3, #0]
;    b    .L27
    b    Jmp10
;.L25:
Jmp7
    ldr    r3, [r7, #12]
    ldr    r3, [r3, #68]
    add    r2, r3, #1
    ldr    r3, [r7, #12]
    str    r2, [r3, #68]
;    b    .L27
    b    Jmp10
;.L30:
Jmp8
    nop
;    b    .L27
    b    Jmp10
;.L31:
Jmp9
    nop
;.L27:
Jmp10
    mov    r3, #1
    str    r3, [r7, #16]
;    b    .L28
    b    Jmp12
;.L24:
Jmp11
    mov    r3, #0
    str    r3, [r7, #16]
;.L28:
Jmp12
;@ 489 "port_asm.c" 1
    mov r0, #0                    
    msr basepri, r0                

;@ 0 "" 2
;    .thumb
    THUMB
    ldr    r3, [r7, #16]
    mov    r0, r3
    add    r7, r7, #24
    mov    sp, r7
    pop    {r7, pc}
;    .size    xQueueReceiveFromISR, .-xQueueReceiveFromISR
;///////////////////////////////////////////////////////
;    .section    .rodata
;    AREA    Text, CODE, READONLY ??????????????????????????????????????????????
;    .align    2
    ALIGN    2
;.LC0:
Txt0
;    .ascii    "IDLE\000"
     DCB       "IDLE\000",0
;    .text
;    AREA    Port, CODE, READONLY  ??????????????????????????????????????????????
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    vTaskStartScheduler
    GLOBAL    vTaskStartScheduler
;    .thumb
    THUMB
;    .thumb_func
;    .type    vTaskStartScheduler, %function
;vTaskStartScheduler:
vTaskStartScheduler
;    @ args = 0, pretend = 0, frame = 8
;    @ frame_needed = 1, uses_anonymous_args = 0
    push    {r7, lr}
    sub    sp, sp, #24
    add    r7, sp, #16
;    movw    r3, #:lower16:.LC0
;    movt    r3, #:upper16:.LC0
;    movw    r3, # LDW Txt0
;    movt    r3, # HDW Txt0
    movw    r3, #:lower16:Txt0
    movt    r3, #:upper16:Txt0
    mov    r2, #0
    str    r2, [sp, #0]
    mov    r2, #0
    str    r2, [sp, #4]
    mov    r2, #0
    str    r2, [sp, #8]
    mov    r2, #0
    str    r2, [sp, #12]
    movw    r0, #:lower16:prvIdleTask
    movt    r0, #:upper16:prvIdleTask
    mov    r1, r3
    mov    r2, #64
    mov    r3, #0
    bl    xTaskGenericCreate
    mov    r3, r0
    str    r3, [r7, #4]
    ldr    r3, [r7, #4]
    cmp    r3, #1
;    bne    .L34
    bne    Jmp13
;@ 514 "port_asm.c" 1
    mov r0, #40                                
    msr basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    movw    r3, #:lower16:xSchedulerRunning
    movt        r3, #:upper16:xSchedulerRunning
    mov        r2, #1
    str        r2, [r3, #0]
    movw    r3, #:lower16:xTickCount
    movt        r3, #:upper16:xTickCount
    mov        r2, #0
    str        r2, [r3, #0]
    bl        vConfigureTimerForRunTimeStats
    bl        xPortStartScheduler
;.L34:
Jmp13
    add    r7, r7, #8
    mov    sp, r7
    pop    {r7, pc}
;    .size    vTaskStartScheduler, .-vTaskStartScheduler
;///////////////////////////////////////////////////////
;    .align    2
    ALIGN    2
;    .global    vTaskEndScheduler
    GLOBAL    vTaskEndScheduler
;    .thumb
    THUMB
;    .thumb_func
;    .type    vTaskEndScheduler, %function
;vTaskEndScheduler:
vTaskEndScheduler
;    @ args = 0, pretend = 0, frame = 0
;    @ frame_needed = 1, uses_anonymous_args = 0
    push    {r7, lr}
    add    r7, sp, #0
;@ 546 "port_asm.c" 1
    mov r0, #40                                
    msr basepri, r0                            

;@ 0 "" 2
;    .thumb
    THUMB
    movw    r3, #:lower16:xSchedulerRunning
    movt    r3, #:upper16:xSchedulerRunning
    mov    r2, #0
    str    r2, [r3, #0]
    bl    vPortEndScheduler
    pop    {r7, pc}
;    .size    vTaskEndScheduler, .-vTaskEndScheduler
;    .ident    "GCC: (Sourcery G++ Lite 2010q1-188) 4.4.1"
    ALIGN    2
    nop
    nop
    nop
    END
