/*
 * mbed Application program for the mbed
 *  FlashAir Check program /monitor part
 *
 * Copyright (c) 2015,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May        5th, 2015
 *      Revised:    August    27th, 2019
 */

/*
 *---------------- REFERENCE ---------------------------------------------------
 * Original Source Information
 * 1) FatFs sample program
 *      ChaN FatFs  http://elm-chan.org/
 *          http://elm-chan.org/fsw/ff/00index_j.html
 * 2) FlashAir Arduino sample program
 *      FlashAir Developers site
 *          https://flashair-developers.com/ja/documents/tutorials/arduino/
 * 3) "mbed＋FlashAirで直ツイート！"
 *      by ban4jp - ( https://developer.mbed.org/users/ban4jp/ )
 *          https://developer.mbed.org/users/ban4jp/notebook
 *                                          /ja-direct-tweet-for-flashair/
 *          https://developer.mbed.org/users/ban4jp/code/FlashAir_Twitter/
 */
 
//  Definition -----------------------------------------------------------------
#define DW_CHAR         sizeof(char)
#define DW_SHORT        sizeof(short)
#define DW_LONG         sizeof(long)

/* These types must be 16-bit, 32-bit or larger integer */
typedef int             INT;
typedef unsigned int    UINT;

/* These types must be 8-bit integer */
typedef char            CHAR;
typedef unsigned char   UCHAR;
typedef unsigned char   BYTE;

/* These types must be 16-bit integer */
typedef short           SHORT;
typedef unsigned short  USHORT;
typedef unsigned short  WORD;
typedef unsigned short  WCHAR;

/* These types must be 32-bit integer */
typedef long            LONG;
typedef unsigned long   ULONG;
typedef unsigned long   DWORD;
typedef unsigned long long  DDWORD;

//  Function prototypes --------------------------------------------------------
static void v_next(char *ptr);
static void d_next(char *ptr);
static void c_next(char *ptr);
static void m_next(char *ptr);
static void r_next(char *ptr);
static void t_next(char *ptr);
static void isdio_mon(char *ptr);
static void ap_mon(char *ptr);
static void sta_mon(char *ptr);

static void crlf(void);
static FRESULT scan_files(char* path);
static void put_rc(FRESULT rc);
static void file_inf(char *ptr);
static void get_line(char *buff, int len);
static void put_dump(void* buff, unsigned long addr, int len, int width);
static void chk_and_set_time(char *ptr);
static int xatoi(char **str, long *res);

// iSDIO
static void isdio_help_massage(void);
void printByte(uint8_t value);
void printBytes(uint8_t* p, uint32_t len);
void printIPAddress(uint8_t* p);
void printHex(uint8_t* p, uint32_t len);
uint8_t iSDIO_establish(uint32_t sequenceId);
uint8_t iSDIO_connect(uint32_t sequenceId,
                      const char* ssid, const char* networkKey);
uint8_t iSDIO_disconnect(uint32_t sequenceId);
uint8_t iSDIO_waitResponse(uint32_t sequenceId);
uint8_t iSDIO_scan(uint32_t sequenceId);
uint8_t iSDIO_showScanResult(void);
uint8_t iSDIO_status(void);
