/*
 * Mbed Application program
 *  FlashAir control program
 *
 * Copyright (c) 2018,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      4th, 2018
 *      Revised:    August    28th, 2019
 */

/*
 * FlashAir:
 *  https://flashair-developers.com/ja/
 *
 * Reference program:
 *  https://os.mbed.com/users/mbed_crane_elec/code/FlashAir_iSDIO_sample_OS5_/
 *  https://os.mbed.com/users/ban4jp/code/FlashAir_Twitter/
 *
 * Tested board on Nucleo-F446RE
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "FlashAir_iSDIO.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
Serial pc(USBTX, USBRX, 115200);
Serial console(A0, A1); // TX, RX
//               mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)
FlashAir_iSDIO sd(D11,             D12,       D13, D10, "sd", &console);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
extern void mon (void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    while(true) {
        mon();
    }
}
