//----------------------------------------------------------
//  Simultanuous AD Conversion by interrupt using
//  ADC2 and ADC3 on STM32F446 ---- Header
//
//  STM32F446 の ADC2, ADC3 を使って同時に AD 変換を開始し，
//  割り込みによりアナログ信号を入力するクラス（ヘッダ）
//      AdcDual クラスの派生クラス
//
//  2016/11/12, Copyright (c) 2016 MIKAMI, Naoki
//----------------------------------------------------------

#include "F446_ADC.hpp"

namespace Mikami
{

#ifndef F446_ADC_DUAL_INTERRUPT_HPP
#define F446_ADC_DUAL_INTERRUPT_HPP

    class AdcDual_Intr : public AdcDual
    {
    public:
        AdcDual_Intr(int frequency) : AdcDual(frequency)
        {   ADC2->CR1 |= ADC_CR1_EOCIE; }

        // -1.0f <= ad1, ad2 <= 1.0f
        virtual void Read(float &ad1, float &ad2)
        {
            ad1 = ToFloat(ADC2->DR);
            ad2 = ToFloat(ADC3->DR);
        }

        // 0 <= ad1, ad2 <= 4095
        virtual void Read(uint16_t &ad1, uint16_t &ad2)
        {
            ad1 = ADC2->DR;
            ad2 = ADC3->DR;
        }

        // Set interrupt vector and enable IRQ of ADC
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
            NVIC_EnableIRQ(ADC_IRQn);                   // See "core_cm4.h"
        }
        
        void DisableAdcIntr()
        {   NVIC_DisableIRQ(ADC_IRQn); }
        
    private:
        // for inhibition of copy constructor
        AdcDual_Intr(const AdcDual_Intr&);
        // for inhibition of substitute operator
        AdcDual_Intr& operator=(const AdcDual_Intr&);     
    };

#endif  // F446_ADC_DUAL_INTERRUPT_HPP

//------------------------------------------------------------------------------

#ifndef F446_ADC_SINGLE_INTERRUPT_HPP
#define F446_ADC_SINGLE_INTERRUPT_HPP

    class AdcSingle_Intr : public AdcSingle
    {
    public:
        AdcSingle_Intr(int frequency) : AdcSingle(frequency)
        {   ADC2->CR1 |= ADC_CR1_EOCIE; }

        virtual void Read(float &ad)
        {
            ad = ToFloat(ADC2->DR);
        }

        virtual void Read(uint16_t &ad)
        {
            ad = ADC2->DR;
        }

        // Set interrupt vector and enable IRQ of ADC
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
            NVIC_EnableIRQ(ADC_IRQn);                   // See "core_cm4.h"
        }
        
        void DisableAdcIntr()
        {   NVIC_DisableIRQ(ADC_IRQn); }
        
    private:
        // for inhibition of copy constructor
        AdcSingle_Intr(const AdcSingle_Intr&);
        // for inhibition of substitute operator
        AdcSingle_Intr& operator=(const AdcSingle_Intr&);     
    };
#endif  // F446_ADC_SINGLE_INTERRUPT_HPP

}

