"""
/*
 * Font converter
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:     May        4th, 2018
 *      Revised:     May       14th, 2018
 */
"""
import numpy as np
import datetime
import os


## -------- USER MODIFICATION ARE ------------------------------------
# modify your condition below
font_num = 8

if font_num==0:
    file_name  =  "IPAexGothicB13x14"
    width_bit  = 13
    height_bit = 14
    org_bit_x  = 13
    org_byte_x =  2
    new_byte_x =  2
    new_bit_y  = 16
elif font_num==1:
    file_name  =  "IPAexGothicB16x16"
    width_bit  = 16
    height_bit = 16
    org_bit_x  = 16
    org_byte_x =  2
    new_byte_x =  2
    new_bit_y  = 16
elif font_num==2:
    file_name  =  "IPAexGothicB21x21"
    width_bit  = 21
    height_bit = 21
    org_bit_x  = 21
    org_byte_x =  3
    new_byte_x =  3
    new_bit_y  = 24
elif font_num==3:
    file_name  =  "IPAexGothicB24x24"
    width_bit  = 24
    height_bit = 24
    org_bit_x  = 24
    org_byte_x =  3
    new_byte_x =  3
    new_bit_y  = 24
elif font_num==4:
    file_name  =  "IPAexGothicB28x29"
    width_bit  = 28
    height_bit = 29
    org_bit_x  = 28
    org_byte_x =  4
    new_byte_x =  4
    new_bit_y  = 32
elif font_num==5:
    file_name  =  "IPAexGothicB33x35"
    width_bit  = 33
    height_bit = 35
    org_bit_x  = 33
    org_byte_x =  5
    new_byte_x =  5
    new_bit_y  = 40
elif font_num==6:
    file_name  =  "IPAexGothicB38x40"
    width_bit  = 38
    height_bit = 40
    org_bit_x  = 38
    org_byte_x =  5
    new_byte_x =  5
    new_bit_y  = 40
elif font_num==7:
    file_name  =  "IPAexGothicB48x48"
    width_bit  = 48
    height_bit = 48
    org_bit_x  = 48
    org_byte_x =  6
    new_byte_x =  6
    new_bit_y  = 48
elif font_num==8:
    file_name  =  "IPAexGothicB96x96"
    width_bit  = 96
    height_bit = 96
    org_bit_x  = 96
    org_byte_x = 12
    new_byte_x = 12
    new_bit_y  = 96


## ----- YOU DON'T NEED ANY MODIFICATION FROM HERE TO END ----------
src_file_name = file_name + ".txt"
out_file_name = file_name + "_converted.txt"
#wxh_name = str(width_bit) + str(height_bit)
wh_name  = str(width_bit) + str(height_bit)
output_font_file_name = "Font" + wh_name + ".c"
now = datetime.datetime.now()
print(src_file_name)
print(out_file_name)
print(output_font_file_name)
print(now)

## Step 1 ------- Read Font file -------------------------------------
## step11        -> only get num & length
print("###### Read a file into Array ######");
file = open(src_file_name,'r')
string = file.readline()
while string:
    #print(string)
    string = file.readline()
    if string.find('{') != -1:
        break
num=0
while string:
    string = file.readline()
    #print(string)
    if string.find('}') != -1:
        break
    font_data = string.split()
    font_data.pop(0)
    font_data.remove('//')
    font_data.remove('Code')
    font_data.remove('for')
    font_data.remove('char')
    last = font_data.pop()
    if last == '0x00,':
        font_data.append('0x00,')
    length = len(font_data)
    num = num+1
print("num=", num, "length=", length)
file.close()
# step12        -> Data into array
temp_data=np.zeros((num,length))
temp_comment=np.chararray((num,2),itemsize=20)
file = open(src_file_name,'r')
string = file.readline()
while string:
    #print(string)
    string = file.readline()
    if string.find('{') != -1:
        break
num=0
length=0
while string:
    string = file.readline()
    #print(string)
    if string.find('}') != -1:
        break
    font_data = string.split()
    temp_comment[num][0]=font_data.pop(0)
    font_data.remove('//')
    font_data.remove('Code')
    font_data.remove('for')
    font_data.remove('char')
    last = font_data.pop()
    if last == '0x00,':
        temp_comment[num][1]="NONE"
        font_data.append('0x00,')
    else:
        temp_comment[num][1]=last
    length = len(font_data)
    #print(length)
    for n in range(length):
        temp_data[num][n] = float(int(font_data[n].replace(',', ''),16))
    num = num+1
print("num=", num, "length=", length)
print("Shape of temp_data ",temp_data.shape)
map(str, temp_comment)
#print(temp_comment)
#np.savetxt("temp0.txt",temp_data,fmt="%.0f",delimiter=",")
file.close()
print("###### Finsh ########")


## Step 2 ------- Make temporary file --------------------------------
## step21        -> Preparation
array  = num
axis_x = width_bit
axis_y = height_bit
# step22        -> Make temporary file
temp_array = np.zeros((array,new_byte_x*new_bit_y)) # not original size but new size
print("###### Start convertion ########");
for n in range(array):
    for i in range(new_byte_x):
        for j in range(new_bit_y):
            if j < org_bit_x:
                temp_array[n][i*new_bit_y+j] = temp_data[n][i+org_byte_x*j]
            else:
                temp_array[n][i*new_bit_y+j] = 0
print("--- Original ------------")     
print(temp_data)
print("--- Converted -----------")
print(temp_array)
#np.savetxt("temp1.txt",  temp_array, fmt="%.0f",  delimiter=",")
print("###### Finsh ########")


## Step 3 ------- Change row & column and make -----------------------
final_array = np.zeros((array,new_byte_x*new_bit_y))
print("###### Change row & column ######")
for n in range(array):
    for i in range(int(new_bit_y/8)):
        for j in range(new_byte_x):
            k = i*new_byte_x*8+j*8
            m = i*new_byte_x*8+j
            final_array[n][0*new_byte_x+m] = ((int(temp_array[n][0+k]) & 0x01) << 7) + ((int(temp_array[n][1+k]) & 0x01) << 6) +\
                ((int(temp_array[n][2+k]) & 0x01) << 5) + ((int(temp_array[n][3+k]) & 0x01) << 4) +\
                ((int(temp_array[n][4+k]) & 0x01) << 3) + ((int(temp_array[n][5+k]) & 0x01) << 2) +\
                ((int(temp_array[n][6+k]) & 0x01) << 1) + ((int(temp_array[n][7+k]) & 0x01) << 0)
            final_array[n][1*new_byte_x+m] = ((int(temp_array[n][0+k]) & 0x02) << 6) + ((int(temp_array[n][1+k]) & 0x02) << 5) +\
                ((int(temp_array[n][2+k]) & 0x02) << 4) + ((int(temp_array[n][3+k]) & 0x02) << 3) +\
                ((int(temp_array[n][4+k]) & 0x02) << 2) + ((int(temp_array[n][5+k]) & 0x02) << 1) +\
                ((int(temp_array[n][6+k]) & 0x02) << 0) + ((int(temp_array[n][7+k]) & 0x02) >> 1)
            final_array[n][2*new_byte_x+m] = ((int(temp_array[n][0+k]) & 0x04) << 5) + ((int(temp_array[n][1+k]) & 0x04) << 4) +\
                ((int(temp_array[n][2+k]) & 0x04) << 3) + ((int(temp_array[n][3+k]) & 0x04) << 2) +\
                ((int(temp_array[n][4+k]) & 0x04) << 1) + ((int(temp_array[n][5+k]) & 0x04) << 0) +\
                ((int(temp_array[n][6+k]) & 0x04) >> 1) + ((int(temp_array[n][7+k]) & 0x04) >> 2)
            final_array[n][3*new_byte_x+m] = ((int(temp_array[n][0+k]) & 0x08) << 4) + ((int(temp_array[n][1+k]) & 0x08) << 3) +\
                ((int(temp_array[n][2+k]) & 0x08) << 2) + ((int(temp_array[n][3+k]) & 0x08) << 1) +\
                ((int(temp_array[n][4+k]) & 0x08) << 0) + ((int(temp_array[n][5+k]) & 0x08) >> 1) +\
                ((int(temp_array[n][6+k]) & 0x08) >> 2) + ((int(temp_array[n][7+k]) & 0x08) >> 3)
            final_array[n][4*new_byte_x+m] = ((int(temp_array[n][0+k]) & 0x10) << 3) + ((int(temp_array[n][1+k]) & 0x10) << 2) +\
                ((int(temp_array[n][2+k]) & 0x10) << 1) + ((int(temp_array[n][3+k]) & 0x10) << 0) +\
                ((int(temp_array[n][4+k]) & 0x10) >> 1) + ((int(temp_array[n][5+k]) & 0x10) >> 2) +\
                ((int(temp_array[n][6+k]) & 0x10) >> 3) + ((int(temp_array[n][7+k]) & 0x10) >> 4)
            final_array[n][5*new_byte_x+m]=  ((int(temp_array[n][0+k]) & 0x20) << 2) + ((int(temp_array[n][1+k]) & 0x20) << 1) +\
                ((int(temp_array[n][2+k]) & 0x20) << 0) + ((int(temp_array[n][3+k]) & 0x20) >> 1) +\
                ((int(temp_array[n][4+k]) & 0x20) >> 2) + ((int(temp_array[n][5+k]) & 0x20) >> 3) +\
                ((int(temp_array[n][6+k]) & 0x20) >> 4) + ((int(temp_array[n][7+k]) & 0x20) >> 5)
            final_array[n][6*new_byte_x+m]=  ((int(temp_array[n][0+k]) & 0x40) << 1) + ((int(temp_array[n][1+k]) & 0x40) << 0) +\
                ((int(temp_array[n][2+k]) & 0x40) >> 1) + ((int(temp_array[n][3+k]) & 0x40) >> 2) +\
                ((int(temp_array[n][4+k]) & 0x40) >> 3) + ((int(temp_array[n][5+k]) & 0x40) >> 4) +\
                ((int(temp_array[n][6+k]) & 0x40) >> 5) + ((int(temp_array[n][7+k]) & 0x40) >> 6)
            final_array[n][7*new_byte_x+m]=  ((int(temp_array[n][0+k]) & 0x80) >> 0) + ((int(temp_array[n][1+k]) & 0x80) >> 1) +\
                ((int(temp_array[n][2+k]) & 0x80) >> 2) + ((int(temp_array[n][3+k]) & 0x80) >> 3) +\
                ((int(temp_array[n][4+k]) & 0x80) >> 4) + ((int(temp_array[n][5+k]) & 0x80) >> 5) +\
                ((int(temp_array[n][6+k]) & 0x80) >> 6) + ((int(temp_array[n][7+k]) & 0x80) >> 7)
print(temp_array)
print(final_array)
print("###### Finsh ########")
print("###### Created ", out_file_name, " file ######")
np.savetxt(out_file_name,  final_array, fmt="%.0f",  delimiter=",")


## Step 4------- Format for C source code ----------------------------
print("###### Start Formatting ########");
file_r = open(out_file_name,'r')
file_w = open(output_font_file_name,'a')
file_w.write("//---------------------------------------------------------------\n")
file_w.write("// This is Font file created by JH1PJL\n//\n")
comment = "// created on   " + str(now) + "\n//\n"
file_w.write(comment)
comment = "//  Oroginal Font file = " + file_name + "\n//   IPAex Font (IPAexGothic)   ipaexg00301.zip\n"
file_w.write(comment)
file_w.write("//    https://ja.osdn.net/projects/ipafonts/releases/47610\n//\n")
file_w.write("//  Convert by GLCD Font Creator\n")
file_w.write("//    https://www.mikroe.com/glcd-font-creator\n")
file_w.write("//---------------------------------------------------------------\n\n")
comment = "#include  \"fonts.h\"" + "\n\n"
file_w.write(comment)
comment = "const uint8_t Font" + wh_name + "_Table[] = \n"
file_w.write(comment)
file_w.write("{\n")
n=0
string = file_r.readline()
data_common = ',' + ' ' + '/' + '/'
data_cr = '\n'
while string:
    string = string + ','
    file_w.write(string)
    string = file_r.readline()
    n=n+1
file_w.write("};\n")
file_w.write(" \n")
comment = "sFONT Font" + wh_name + " = {\n"
file_w.write(comment)
comment = " Font" + wh_name + "_Table,\n"
file_w.write(comment)
comment = " " + str(org_bit_x) + ", // width \n"
file_w.write(comment)
comment = " " + str(new_bit_y) + "  // Height\n"
file_w.write(comment)
file_w.write("};\n")
file_w.close()
file_r.close()
print("###### Finsh ########")
print("###### Created ", output_font_file_name," file ######")
os.remove(out_file_name)
