// Original
//      https://os.mbed.com/teams/ST/code/DISCO-F769NI_LCD_demo/
//
// Modified by K.Arai
//      October   14th, 2019
//

#include "select_program.h"
//#define EXAMPLE_2_LCD
#ifdef EXAMPLE_2_LCD

#define FOREVER 0x7fffffff

#include "mbed.h"
#include "LCD_DISCO_F769NI.h"

LCD_DISCO_F769NI lcd;
DigitalOut led_red(LED1);
DigitalOut led_green(LED2);
Serial pc(USBTX, USBRX, 115200);

int main()
{
    led_green = 0;
    led_red = 1;
    uint32_t line = 2;
    char buf[64];

    pc.printf("\x1b[2J\x1b[H %s\r\n %s %s (UTC)\r\n",
              __FILE__, __DATE__, __TIME__);
    printf(" LCD EXAMPLE FOR DISCO-F769NI:\r\n");
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0,
                        LINE(++line),
                        (uint8_t *)"MBED EXAMPLE",
                        CENTER_MODE);
    ThisThread::sleep_for(1000);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(0,
                        LINE(line += 2),
                        (uint8_t *)"DISCOVERY STM32F769NI",
                        CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0,
                        LINE(++line),
                        (uint8_t *)"STM32F769NIH6",
                        CENTER_MODE);
    lcd.DisplayStringAt(0,
                        LINE(++line),
                        (uint8_t *)"2Mbytes/Flash",
                        CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_MAGENTA);
    lcd.DisplayStringAt(0,
                        LINE(++line),
                        (uint8_t *)"512+16+4Kbytes/RAM",
                        CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_RED);
    sprintf(buf, "%s", __FILE__);
    lcd.DisplayStringAt(20,
                        LINE(line += 4),
                        (uint8_t *)buf,
                        LEFT_MODE);
    sprintf(buf, "%s %s (UTC)", __DATE__, __TIME__);
    lcd.DisplayStringAt(20,
                        LINE(++line),
                        (uint8_t *)buf,
                        LEFT_MODE);
    led_green = 1;
    led_red = 0;

    while(true) {
        ThisThread::sleep_for(FOREVER);
    }
}

#endif
