/*
 * Mbed Application program / Blinky
 *
 * Copyright (c) 2018,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April     10th, 2018
 *      Revised:    October   14th, 2019
 */

#include "select_program.h"
//#define EXAMPLE_0_BLINKY_LED
#ifdef EXAMPLE_0_BLINKY_LED

//  Include --------------------------------------------------------------------
#include "mbed.h"

//  Definition -----------------------------------------------------------------
#define LEDON   1
#define LEDOFF  0

#define FOREVER 0x7fffffff

//  Constructor ----------------------------------------------------------------
DigitalOut  my_led1(LED1);
DigitalOut  my_led2(LED2);
DigitalOut  my_led3(LED3);
Serial pc(USBTX, USBRX, 115200);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
static void tsk_0(void const *args);
static void tsk_1(void const *args);
static void tsk_2(void const *args);
static void tsk_3(void const *args);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
osThreadDef(tsk_0, osPriorityNormal,1024);
osThreadDef(tsk_1, osPriorityNormal,1024);
osThreadDef(tsk_2, osPriorityNormal,1024);
osThreadDef(tsk_3, osPriorityNormal,1024);

int main()
{
    pc.printf("\x1b[2J\x1b[H %s\r\n %s %s (UTC)\r\n",
              __FILE__, __DATE__, __TIME__);
    printf(" LED BLINKY EXAMPLE FOR DISCO-F769NI:\r\n");
    osThreadId  id0, id1, id2, id3;
    id0 = osThreadCreate(osThread(tsk_0), NULL);
    id1 = osThreadCreate(osThread(tsk_1), NULL);
    id2 = osThreadCreate(osThread(tsk_2), NULL);
    id3 = osThreadCreate(osThread(tsk_3), NULL);
    pc.printf("id0=0x%x, id1=0x%x, id2=0x%x, id3=0x%x\r\n",
              (uint32_t)id0, (uint32_t)id1, (uint32_t)id2, (uint32_t)id3);
    while(true) {
        ThisThread::sleep_for(FOREVER);
    }
}

void tsk_0(void const *args)
{
    Timer t;
    uint32_t count = 0;

    while(true) {
        t.reset();
        t.start();
        pc.printf("%5d\r\n", count++);
        uint32_t wait = 1000 - t.read_ms();
        ThisThread::sleep_for(wait);
    }
}

void tsk_1(void const *args)
{
    while(true) {
        my_led1 = LEDON;
        ThisThread::sleep_for(5);
        my_led1 = LEDOFF;
        ThisThread::sleep_for(1995);
    }
}

void tsk_2(void const *args)
{
    while(true) {
        my_led2 = LEDON;
        ThisThread::sleep_for(5);
        my_led2 = LEDOFF;
        ThisThread::sleep_for(2995);
    }
}

void tsk_3(void const *args)
{
    while(true) {
        my_led3 = LEDON;
        ThisThread::sleep_for(5);
        my_led3 = LEDOFF;
        ThisThread::sleep_for(3995);
    }
}

#endif
