/*
 * Mbed Application program
 *  SD Card file control function with FatFs on Mbed-os5
 *
 * Copyright (c) 2018,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      7th, 2018
 *      Revised:    October   14th, 2019
 */

#include "select_program.h"
//#define EXAMPLE_4_MICROSD
#ifdef EXAMPLE_4_MICROSD

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "FATFileSystem.h"
#include    "SDBlockDeviceDISCOF769NI.h"
#include    "mon.h"

//  Definition -----------------------------------------------------------------
#define     USER_SW_ON      1

//  Constructor ----------------------------------------------------------------
DigitalOut      led(LED1);
DigitalIn       user_sw(USER_BUTTON);
Serial          pc(USBTX, USBRX, 115200);
// Instantiate the Block Device for sd card on DISCO-F769NI
SDBlockDeviceDISCOF769NI bd;
FATFileSystem   fs("fs");

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
const char * opening_msg0 = "microSD Card test program";
const char * opening_msg1 = " -> run on Mbed OS-5\r\n";

//  Function prototypes --------------------------------------------------------
void return_error (int ret_val);
void errno_error (void* ret_val);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    time_t      seconds;
    uint32_t data0 = 10000U;
    uint32_t data1 = 20000U;
    uint32_t data2 = 30000U;
    uint32_t data3 = 40000U;
    uint32_t data4 = 50000U;
    uint32_t data5 = 60000U;

    pc.printf("\x1b[2J\x1b[H %s\r\n %s %s (UTC)\r\n",
              __FILE__, __DATE__, __TIME__);
    printf(" microSD FOR DISCO-F769NI:\r\n");

    //pc.printf("line:%d\r\n", __LINE__);
    pc.printf("\r\nStart\r\n");
    int error = 0;
    pc.printf("Welcome to the filesystem example.\r\n");
    pc.printf("Mounting the filesystem on \"/fs\". \r\n");
    error = fs.mount(&bd);
    return_error(error);

    if (user_sw == USER_SW_ON) {
        mon();
    }

    FILE* fp = fopen("/fs/mydata.txt", "a");
    errno_error(fp);
    if (fp != 0) {
        pc.printf("%s%s",  opening_msg0, opening_msg1);
        fprintf(fp,"%s%s", opening_msg0, opening_msg1);
    } else {
        pc.printf("ERROR\r\n");
    }
    fclose(fp);
    while (pc.readable()) {
        char c = pc.getc(); // dummy read
    }
    while (true) {
        uint32_t size = get_disk_freespace();
        pc.printf("free %u  ", size);
        fp = fopen("/fs/mydata.txt", "a");
        /*if (size <= DISK_SIZE_LIMIT) {
            pc.printf("Reached RAM Disk size limitation!!\r\n");
            break;
        }*/
        errno_error(fp);
        if(fp != 0) {
            char tmp[64];
            seconds = time(NULL);
            strftime(tmp, 64, "DATE %H:%M:%S,%Y/%m/%d,", localtime(&seconds));
            pc.printf("%s", tmp);
            fprintf(fp, "%s", tmp);
            pc.printf("%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                      ++data0, ++data1, ++data2, ++data3, ++data4, ++data5);
            fprintf(fp, "%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                        data0,   data1,   data2,   data3,   data4,   data5);
            fclose(fp);
        } else {
            pc.printf("ERROR (Cannot open /fs/mydata.txt)\r\n");
            // start retry
            error = fs.mount(&bd);
            return_error(error);
            FILE* fp = fopen("/fs/mydata.txt", "a");
            errno_error(fp);
            if (fp != 0) {
                pc.printf("%s%s",  opening_msg0, opening_msg1);
                fprintf(fp,"%s%s", opening_msg0, opening_msg1);
                fclose(fp);
            } else {
                system_reset();
            }
        }
        ThisThread::sleep_for(100);
        if (user_sw == USER_SW_ON) {
            break;
        }
        if (pc.readable()) {
            mon();
        }
        led = !led;
    }
    while(true) {
        mon();
        NVIC_SystemReset();
    }
}

void return_error (int ret_val)
{
    if (ret_val) {
        pc.printf("retrun error/Failure. %d\r\n", ret_val);
    }
}

void errno_error (void* ret_val)
{
    if (ret_val == NULL) {
        pc.printf("error #/Failure. %d \r\n", errno);
    }
}

#endif
