// Original
//      https://os.mbed.com/handbook/USBHostSerial
//
// Modified by K.Arai
//      October   14th, 2019
//

#include "select_program.h"
//#define EXAMPLE_6_USBHOST_SERIAL
#ifdef EXAMPLE_6_USBHOST_SERIAL

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "USBHostSerial.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut led(LED1);
Serial pc(USBTX, USBRX, 115200);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
static void serial_task(void const *args);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
osThreadDef(serial_task, osPriorityNormal, 4096);

int main()
{
    pc.printf("\x1b[2J\x1b[H %s\r\n %s %s (UTC)\r\n",
              __FILE__, __DATE__, __TIME__);
    printf(" USB HOST serial for DISCO-F769NI:\r\n");   
    osThreadCreate(osThread(serial_task), NULL);
    while(true) {
        led=!led;
        ThisThread::sleep_for(1000);
    }
}

void serial_task(void const*)
{
    USBHostSerial usb_ser;
    wait(0.5f);
    while(true) {
        // try to connect a USB serial device
        while(!usb_ser.connect()) {
            ThisThread::sleep_for(500);
        }
        // in a loop, print all characters received
        // if the device is disconnected, we try to connect it again
        while (true) {
            // if device disconnected, try to connect it again
            if (!usb_ser.connected()) {
                break;
            }
            // print characters received
            while (usb_ser.available()) {
                pc.printf("%c", usb_ser.getc());
            }
        }
    }
}

#endif

#if 0
// USBDevice example
#include "mbed.h"
#include "USBSerial.h"
//Virtual serial port over USB
USBSerial serial;
Serial pc(USBTX, USBRX, 115200);
int main(void)
{
    uint32_t n = 0;
    while(1) {
        serial.printf("I am a virtual serial port\r\n");
        pc.printf("I am also a virtual serial port. loop count = %d\r\n", n++);
    }
}
#endif