// Original
//      https://os.mbed.com/teams/ST/code/DISCO-F769NI_TOUCHSCREEN_demo/
//
// Modified by K.Arai
//      October   14th, 2019
//

#include "select_program.h"
//#define EXAMPLE_3_LCD_TOUCH
#ifdef EXAMPLE_3_LCD_TOUCH

#include "mbed.h"
#include "stm32f769i_discovery.h"
#include "stm32f769i_discovery_ts.h"
#include "stm32f769i_discovery_lcd.h"

TS_StateTypeDef  TS_State = {0};
Serial pc(USBTX, USBRX, 115200);

int main()
{
    uint16_t x1, y1;

    pc.printf("\x1b[2J\x1b[H %s\r\n %s %s (UTC)\r\n",
              __FILE__, __DATE__, __TIME__);
    printf(" TOUCHSCREEN EXAMPLE FOR DISCO-F769NI:\r\n");

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);

    /* Touchscreen initialization */
    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) == TS_ERROR) {
        printf("BSP_TS_Init error\r\n");
    }

    /* Clear the LCD */
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    /* Set Touchscreen Demo1 description */
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0,
                            10,
                            (uint8_t *)"Touchscreen basic example",
                            CENTER_MODE);

    while (1) {
        BSP_TS_GetState(&TS_State);
        if(TS_State.touchDetected) {
            /* One or dual touch have been detected          */

            /* Get X and Y position of the first touch post calibrated */
            x1 = TS_State.touchX[0];
            y1 = TS_State.touchY[0];
            pc.printf("Touch Detected x=%d y=%d\r\n", x1, y1);

            BSP_LCD_SetTextColor(LCD_COLOR_RED);
            BSP_LCD_FillCircle(x1, y1, 20);

            ThisThread::sleep_for(10);
        }
    }
}

#endif
