/*
 * Mbed Application program
 *  UART MP3 Voice Module with 8MB Flash Memory / DFR0534
 *
 * Copyright (c) 2019 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    December  27th, 2019
 *      Revised:    December  29th, 2019
 */

/*
    Reference information:
        http://akizukidenshi.com/catalog/g/gM-13708/
        https://wiki.dfrobot.com/Voice_Module_SKU__DFR0534
    
    Tested on
        Nucleo-F446RE
 */

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "drf0534.h"

//  Definition -----------------------------------------------------------------
#define USE_VOL     1

//  Constructor ----------------------------------------------------------------
Serial  pc(USBTX, USBRX);
DFR0534 mp3(PA_0, PA_1, PA_4);  // tx, rx, busy
#if USE_VOL
AnalogIn pot(A5);
#endif

//  RAM ------------------------------------------------------------------------
char name_buf[32];

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    pc.printf("Start DRF0534 UART MP3 Voice Module\r\n");
    // Set Volume
    mp3.volume_setting(VOL_MAX / 2);
    mp3.command(Increase_the_volume);   // another way
    // Check total MP3 files
    uint32_t num = mp3.total_num_of_audio();
    pc.printf("Number of audio source = %u\r\n", num);
    // Try specific MP3
    mp3.play_one(2);
    while(true) {
        for (uint32_t i = 1; i < num + 1; i++) {
#if USE_VOL
            float an = pot.read();
            an *= VOL_MAX;
            mp3.volume_setting((uint8_t)an);
            pc.printf("VOL = %3.0f, ", an);   // 0 to 30(VOL_MAX)
#endif
            // play one track
            mp3.play_one(i);
            // get file name
            mp3.get_file_name(name_buf);
            pc.printf("Current # of audio = %u, ", mp3.current_num_of_audio());
            pc.printf("File name = %s, ", name_buf);
            pc.printf("playing time = %d [sec]\r\n", mp3.get_play_time());
        }
    }
}
