/*
 * mbed library checking program
 *  D6T-44L-06: D6T MEMS Thermal Sensors
 *  --- High Sensitivity Enables Detection of Stationary Human Presence
 *  https://www.components.omron.com/web/en/product-detail?partNumber=D6T
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    February  16th, 2020
 *      Revised:    February  18th, 2020
 */

/*
    Tested on:
        GR-MANGO(beta version) with 2JCIE-EV01 board
 */

#if 0

#include "mbed.h"
#include "D6T_44L_06.h"

D6T_44L_06 tmp_16array(I2C_SDA, I2C_SCL);

int main(void) {
    float_t t_f[16];

    printf("Start program\r\n");
    ThisThread::sleep_for(200);
    printf("\x1b[2J");                  // Clear screen
    while (1) {
        printf("\x1b[%d;%dH", 0, 0);    // Move cursor (y , x)
        printf("GR-MANGO --> Omron D6T_44L_06, MEMS Thermal Sensor\r\n");
        printf("Sensor chip temperatue: %5.2f\r\n", tmp_16array.read_chip_temp());
        bool result = tmp_16array.read_float_data(t_f);
        for (uint32_t i = 0; i < 16;) {
            printf("%5.2f, ", t_f[i]);
            i++;
            if ((i % 4) == 0){
                printf("\r\n");
            }
        }
        if (result == true){
            printf("Data is valid\r\n");
        } else {
            printf("Data has CRC error\r\n");
        }
        ThisThread::sleep_for(300);
    }
}

#endif