/*
 * mbed Application program for the mbed
 *      LIS3DH ultra low-power high performance 3-axes “nano” accelerometer
 *
 * Copyright (c) 2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: November  29th, 2015
 *      Revised: December  12th, 2015
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//  Include ---------------------------------------------------------------------------------------
#include    "mbed.h"
#include    "LIS3DH.h"

//  Definition ------------------------------------------------------------------------------------

//  Object ----------------------------------------------------------------------------------------
// com
Serial      pc(USBTX, USBRX);      // Communication with Host
I2C         i2c(D14,D15);
// Acc
LIS3DH      acc(i2c, LIS3DH_V_CHIP_ADDR, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);

//  RAM -------------------------------------------------------------------------------------------
float fa[3];    // Acc  0:X, 1:Y, 2:Z
uint32_t n;

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
void display_reg(void);

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
int main(void) {
    n = 1;
    while (true) {
#if OLD_REV  // defined in LIS3DH.h
        acc.read_data(fa);
        pc.printf("%06d,old,[m/s2], %+7.4f,%+7.4f,%+7.4f,", n++, fa[0], fa[1], fa[2]);
        acc.read_mg_data(fa);
        pc.printf("[g],%+7.4f,%+7.4f,%+7.4f \r\n", fa[0], fa[1], fa[2]);
#else
        acc.read_data(fa);
        pc.printf("%06d,new,[m/s2],%+06.4f,%+06.4f,%+06.4f,", n++, fa[0], fa[1], fa[2]);
        acc.read_mg_data(fa);
        pc.printf("[mg],%+6.0f,%+6.0f,%+6.0f \r\n", fa[0], fa[1], fa[2]);
#endif
        wait(0.5);
        if (n%25 == 0){
            display_reg();
        }
    }
}

void display_reg(void){
    pc.printf("LIS3DH ultra low-power high performance 3-axes 'nano' accelerometer\r\n");
    pc.printf(" STATUS_AUX=0x%02x\r\n", acc.read_reg(LIS3DH_STATUS_REG_AUX));
    pc.printf(" OUT_ADC1_L=0x%02x,", acc.read_reg(LIS3DH_OUT_ADC1_L));
    pc.printf(" OUT_ADC1_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_ADC1_H));
    pc.printf(" OUT_ADC2_L=0x%02x,", acc.read_reg(LIS3DH_OUT_ADC2_L));
    pc.printf(" OUT_ADC2_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_ADC2_H));
    pc.printf(" OUT_ADC3_L=0x%02x,", acc.read_reg(LIS3DH_OUT_ADC3_L));
    pc.printf(" OUT_ADC3_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_ADC3_H));
    pc.printf(" INT_COUNTER_REG=0x%02x\r\n", acc.read_reg(LIS3DH_INT_COUNTER_REG));
    pc.printf(" WHO_AM_I=0x%02x\r\n", acc.read_reg(LIS3DH_WHO_AM_I));
    pc.printf(" TEMP_CFG_REG=0x%02x\r\n", acc.read_reg(LIS3DH_TEMP_CFG_REG));
    pc.printf(" CTRL_REG1=0x%02x,", acc.read_reg(LIS3DH_CTRL_REG1));
    pc.printf(" CTRL_REG2=0x%02x,", acc.read_reg(LIS3DH_CTRL_REG2));
    pc.printf(" CTRL_REG3=0x%02x\r\n", acc.read_reg(LIS3DH_CTRL_REG3));
    pc.printf(" CTRL_REG4=0x%02x,", acc.read_reg(LIS3DH_CTRL_REG4));
    pc.printf(" CTRL_REG5=0x%02x,", acc.read_reg(LIS3DH_CTRL_REG5));
    pc.printf(" CTRL_REG6=0x%02x\r\n", acc.read_reg(LIS3DH_CTRL_REG6));
    pc.printf(" REFERENCE=0x%02x\r\n", acc.read_reg(LIS3DH_REFERENCE));
    pc.printf(" STATUS_REG=0x%02x\r\n", acc.read_reg(LIS3DH_STATUS_REG));
    pc.printf(" OUT_X_L=0x%02x,", acc.read_reg(LIS3DH_OUT_X_L));
    pc.printf(" OUT_X_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_X_H));
    pc.printf(" OUT_Y_L=0x%02x,", acc.read_reg(LIS3DH_OUT_Y_L));
    pc.printf(" OUT_Y_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_Y_H));
    pc.printf(" OUT_Z_L=0x%02x,", acc.read_reg(LIS3DH_OUT_Z_L));
    pc.printf(" OUT_Z_H=0x%02x\r\n", acc.read_reg(LIS3DH_OUT_Z_H));
    pc.printf(" FIFO_CTRL_REG=0x%02x,", acc.read_reg(LIS3DH_FIFO_CTRL_REG));
    pc.printf(" FIFO_SRC_REG=0x%02x\r\n", acc.read_reg(LIS3DH_FIFO_SRC_REG));
    pc.printf(" INT1_CFG=0x%02x,", acc.read_reg(LIS3DH_INT1_CFG));
    pc.printf(" INT1_SOURCE=0x%02x,", acc.read_reg(LIS3DH_INT1_SOURCE));
    pc.printf(" INT1_THS=0x%02x,", acc.read_reg(LIS3DH_INT1_THS));
    pc.printf(" INT1_DURATION=0x%02x\r\n", acc.read_reg(LIS3DH_INT1_DURATION));
    pc.printf(" CLICK_CFG=0x%02x,", acc.read_reg(LIS3DH_CLICK_CFG));
    pc.printf(" CLICK_SRC=0x%02x,", acc.read_reg(LIS3DH_CLICK_SRC));
    pc.printf(" CLICK_THS=0x%02x\r\n", acc.read_reg(LIS3DH_CLICK_THS));
    pc.printf(" TIME_LIMIT=0x%02x,", acc.read_reg(LIS3DH_TIME_LIMIT));
    pc.printf(" TIME_LATENCY=0x%02x,", acc.read_reg(LIS3DH_TIME_LATENCY));
    pc.printf(" TIME_WINDOW=0x%02x\r\n", acc.read_reg(LIS3DH_TIME_WINDOW));
}
