/*
 * Mbed Application program
 *   Time-of-Flight ranging and gesture detection sensor / STMicro VL6180XA1
 *    https://os.mbed.com/components/X-NUCLEO-6180XA1-Proximity-and-ambient-l/
 *
 *    Strawberry Linux
 *      https://strawberry-linux.com/catalog/items?code=16180
 *
 *    --------  TESTED ONLY ON Strawberry board --------
 *              With Nucleo-F446RE Mbed board
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    January   25th, 2018
 *      Revised:    Feburary   1st, 2018
 */

/*
 	If you switch MY_LOG definition zero to 1 in vl6180x_platform.h line 37,
 	you may have a trouble for Serial class due to line order VL6180X.h	file
 	and Serial constractor!
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "VL6180X.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut  myled(LED1);
Serial 		pc(USBTX, USBRX);
I2C			i2c(I2C_SDA, I2C_SCL);
VL6180X		sensor(i2c, D8);
Timer       t;


//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{ 
//	int status = 0;
	uint32_t lux;
	uint32_t dist;
    uint32_t count = 0;
    uint32_t tm;

	while (true) {
        t.reset();
        t.start();
        myled = !myled;
		sensor.get_distance(&dist);
		sensor.get_lux(&lux);
		pc.printf("Distance: %4d, Lux: %4d, ", dist, lux);
        tm = t.read_ms();
        wait_ms(200 - tm);
        pc.printf("Looptime: %4d, Count:%5d\r\n", t.read_ms(), count++);
	}
}
