/*
 * Mbed Application program -> Three of VL53L0X's are working together
 *   Time-of-Flight ranging and gesture detection sensor / STMicro VL53L0X
 *      http://www.st.com/ja/imaging-and-photonics-solutions/vl53l0x.html
 *
 *    1) AKIZUKI AE-VL53L0X
 *      http://akizukidenshi.com/catalog/g/gM-12590/
 *    2) SWITCH SCIENCE  Pololu VL53L0X (POLOLU-2490)
 *      https://www.switch-science.com/catalog/2869/
 *    3) SWITCH SCIENCE  VL53L0X (SSCI-028943)
 *      https://www.switch-science.com/catalog/2894/
 *    4) Strawberry Linux
 *      https://strawberry-linux.com/catalog/items?code=15310
 *
 *    ---- Tested AE-VL53L0X BOARD and handmade circuit ----
 *      Tested on below Mbed boards and works fine on mbed-os5
 *          Nucleo-F446RE
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    January   21st, 2018
 *      Revised:    Feburary   6th, 2018 (with updated VL53L0X_simple library)
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "VL53L0X.h"    // revision=7:174594 (as of today)

//  Definition -----------------------------------------------------------------
#warning "New VL53L0X simple lib. was released and this is an example for it.
#warning "Current revision has a trouble with I2C LCD together.
#warning "Investigation is ongoing.

//  Constructor ----------------------------------------------------------------
DigitalOut  myled(LED1);
Serial      pc(USBTX, USBRX);
//I2C         i2c(P0_30, P0_7);     // only for TY51822r3
I2C         i2c(I2C_SDA, I2C_SCL);
VL53L0X     tof_center(i2c, D8);  // XSHUT is mandatory for multi setting
VL53L0X     tof_left(i2c, D9);    // XSHUT is mandatory for multi setting
VL53L0X     tof_right(i2c, D10);  // XSHUT is mandatory for multi setting
Timer       t;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
char *const msg0  = "VL53L0X is running correctly!!\r\n";
char *const msg1  = "VL53L0X -> something is wrong!!\r\n";
char *const msg2  = "#,";
char *const msg3  = "d[mm]=,";
char *const msg4  = "err, ";
char *const msg5  = "VL53[mS]=, ";
char *const msg6  = "all[mS]=, ";
char *const msg_c = "Center";
char *const msg_l = "Left";
char *const msg_r = "Right";

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    int status = VL53L0X_ERROR_NONE;
    uint32_t data_c = 0;
    uint32_t data_l = 0;
    uint32_t data_r = 0;
    uint32_t count  = 0;
    uint32_t tm_sensor;
    uint32_t tm_all_work;
    uint8_t  error_num;

    status = tof_center.init_sensor(0x22 << 1U);// new addres(not equal others)
    pc.printf("--%s--\r\n", msg_c);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    status = tof_left.init_sensor(0x33 << 1U);   // new addres(not equal others)
    pc.printf("--%s--\r\n", msg_l);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    status = tof_right.init_sensor(0x44 << 1U);  // new addres(not equal others)
    pc.printf("--%s--\r\n", msg_r);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    status = tof_center.set_mode(range_long_distance_33ms_200cm);
    //status = tof_center.set_mode(range_hi_accurate_200ms_120cm);
    //status = tof_center.set_mode(range_hi_speed_20ms_120cm);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    status = tof_left.set_mode(range_long_distance_33ms_200cm);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    status = tof_right.set_mode(range_long_distance_33ms_200cm);
    if (status == VL53L0X_ERROR_NONE) {
        pc.printf(msg0);
    } else {
        pc.printf(msg1);
    }
    while(true) {
        t.reset();
        t.start();
        myled = !myled;
        error_num = 0;
        status  = tof_center.get_distance(&data_c);
        if (status) {
            error_num  = 1U << 0;
        }
        status = tof_left.get_distance(&data_l);
        if (status) {
            error_num |= 1U << 1;
        }
        status |= tof_right.get_distance(&data_r);
        if (status) {
            error_num |= 1U << 2;
        }
        tm_sensor = t.read_ms();
        pc.printf("%s%5d,%s%5d,%5d,%5d,",
                  msg2, count++, msg3, data_c, data_l, data_r);
        pc.printf("%s%d,%s%d,%s%1d\r\n",
                  msg5, tm_sensor, msg6, tm_all_work, msg4,error_num);
        tm_all_work = t.read_ms();
        if (tm_all_work < 199) {
            wait_ms(200 - tm_all_work);
        }
    }
}
