/*
 * Mbed-OS5 & OS-2
 *  Check EventTimer behavior
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Revised:    May       12th, 2020
 *      Revised:    May       12th, 2020
 */

#include "mbed.h"

class FlexTicker: public TimerEvent
{
public:
    void attach(void(*fptr)(void)) { _function = Callback<void()>(fptr);}
    void detach() { remove();}
    void setNext(int delay) { insert(event.timestamp + delay);}
    void prime()  { event.timestamp = us_ticker_read();}
protected:
    virtual void handler() { _function.call();}
    unsigned int _delay;
    Callback<void()> _function;
};

DigitalOut led(LED1);
FlexTicker tk;

#define TARGET_TIME     50      // 50us

volatile uint32_t num;
uint32_t time_data[10];

// call by TimerEvent
void pulse_out(void)
{
    led = 1;
    num++;
    time_data[num] = us_ticker_read();
    if (num < 10) {
        tk.setNext(TARGET_TIME);
    }
    led = 0;
}

int main()
{
    printf("MBED_MAJOR_VERSION = %d, ", MBED_MAJOR_VERSION);
    printf("MINOR = %d, ", MBED_MINOR_VERSION);
    printf("PATCH = %d\r\n", MBED_PATCH_VERSION);
    tk.attach(&pulse_out);
    while(true) {
        led = 1;
        num = 0;
        time_data[0] = us_ticker_read();
        tk.prime();
        led = 0;
        tk.setNext(TARGET_TIME);
        //ThisThread::sleep_for(500);
        wait_ms(500);
        for (uint32_t i = 0; i < 9; i++) {
            printf("%d=%4d, ", i, time_data[i+1] - time_data[i]);
        }
        printf("No=time[us]\r\n");
    }
}
