/*
 * mbed Application program / Si5351A sample program
 *  tested on:
 *      ST Nucleo-F411RE & F401RE
 *      LPC1114FN28
 *
 *  Copyright (c) 2016,'17 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  December 28th, 2016
 *      Revised:  January   7th, 2017
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//  Definition -----------------------------------------------------------------
#define BAUD(x)                 pc.baud(x)
#define GETC(x)                 pc.getc(x)
#define PUTC(x)                 pc.putc(x)
#define PRINTF(...)             pc.printf(__VA_ARGS__)
#define READABLE(x)             pc.readable(x)

#define BAUD_RATE 9600

#if 1
#define INCREMENT               // command 1,2,3 -> INCREMENT or TABLE_LOOK
#endif
#if !defined(INCREMENT)
#define TABLE_LOOK
#endif

//  Object ---------------------------------------------------------------------

//  RAM ------------------------------------------------------------------------
char linebuf[64];
int buf_size = sizeof(linebuf);

//  ROM / Constant data --------------------------------------------------------
char *const opening_msg =
                "Si5351 test program, created on UTC: "__DATE__"("__TIME__")";
char *const msg0 =  "output: Please enter freq. ex 1230000";

//  Function prototypes --------------------------------------------------------
void msg_hlp(void);
void test(uint8_t channel);
void test_si5351(void);
void special_command(void);
void put_rn( void );
void put_r( void );
void put_lin( void );
void put_spc( uint8_t n);
int  xatoi(char **str, int32_t *res);
void get_line(char *buff, int len);
void get_line_no_param(char *buff);
void delay(int32_t time);