/*
 * Mbed Application program
 *  check Piezo Buzzer function
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Modify:     Feburary  28th, 2018
 *      Revised:    March      3rd, 2018
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "piezo_bz.h"

//  Definition -----------------------------------------------------------------

//  Object ---------------------------------------------------------------------
Serial      pc(USBTX, USBRX);
//PIEZO_BZ    bz(D8, 500, 500);
PIEZO_BZ    bz(D8, 500, CONTINUOUS_MODE);   // 500Hz Continuous Mode

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    while (true) {
        for (uint32_t i = 1; i < 110; i++) {
            uint32_t freq = (500 * i) /10;
            bz.start();
            wait(2.0f);
            bz.stop();
            wait(0.1f);
            bz.change_frequency(freq);
            pc.printf("Freq= %4d [Hz]\r\n", freq);
        }
    }
}
