/*
 * Mbed Application program / Akizuki 7-segment LED driver [OSL10564-74HC595-x]
 *      AKIZUKI AE-7SEG-BOARD-KIT-BLUE
 *      http://akizukidenshi.com/catalog/g/gK-10344/
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    January    7th, 2018
 *      Revised:    January   22nd, 2018
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "7segLed_HC595.h"

//  Definition -----------------------------------------------------------------
#define NUM_OF_DIGIT    6

#define KEYIN_THEN_EXIT_WHILE() {if(exit_while_loop_when_keyinput()){ break;}}

//  Constructor ----------------------------------------------------------------
Serial      pc(USBTX, USBRX);
#if defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F411RE)\
 || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_L152RE)\
 || defined(TARGET_NUCLEO_L073RZ) || defined(TARGET_NUCLEO_L053R8)\
 || defined(TARGET_NUCLEO_L476RG)
//                SPI MOSI,SCLK,any port, PWM, number of digit
SevenSegLed led_7segs(D4,  D3,  D5,       D6,  NUM_OF_DIGIT);
#elif defined(TARGET_NUCLEO_F334R8)
//                SPI MOSI,SCLK,any port, PWM, number of digit
SevenSegLed led_7segs(D4,  D3,  D5,       D7,  NUM_OF_DIGIT);
#elif defined(TARGET_NUCLEO_F303K8)
//                SPI MOSI,SCLK,any port, PWM, number of digit
SevenSegLed led_7segs(A6,  A4,  A5,       A3,  NUM_OF_DIGIT);
#elif TARGET_Freescale
//                SPI MOSI,SCLK,any port, PWM, number of digit
SevenSegLed led_7segs(D11, D13, D12,     D10,  NUM_OF_DIGIT);
#else
#error    "Please set your own SevenSegLed constractor!"
#endif
DigitalOut  myled(LED1);
AnalogIn    vol(A0);

//  RAM ------------------------------------------------------------------------
time_t seconds;

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
bool exit_while_loop_when_keyinput(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    //--------------------------------------------------------------------------
    pc.printf("Hit any key to go next step\r\n");
    pc.printf("Step1\r\n");
    {
        uint32_t max = 9;
        for (uint32_t i = 1; i < NUM_OF_DIGIT; i++) {
            max = max * 10 + 9;
        }
        pc.printf("max = %d\r\n", max);
        led_7segs.zero_suppress(true);
        int32_t count = 0;
        while(true) {
            led_7segs = count++;
            if (count > max) {
                count = 0;
            }
            float wait_time = 5.0f / (float)(count + 1);
            if (wait_time > 0.01f) {
                wait(wait_time);
            }
            KEYIN_THEN_EXIT_WHILE();
        }
    }
    //--------------------------------------------------------------------------
    pc.printf("Step2\r\n");
    {
        char buf[16];

        led_7segs.zero_suppress(false);
        float led_bright = 0.5f;
        while(true) {
            time_t seconds = time(NULL);
            strftime(buf, 10, "%H.%M.%S", localtime(&seconds));
            //strftime(buf, 10, "1.2.3.4.%S", localtime(&seconds));
            pc.printf("%s\r\n", buf);
            led_7segs.put_ascii(buf);
            led_7segs.brightness(led_bright);
            if (led_bright == 0.5f) {
                led_bright = 1.0f;
            } else {
                led_bright = 0.5f;
            }
            wait(1.0f);
            KEYIN_THEN_EXIT_WHILE();
        }
    }
    //--------------------------------------------------------------------------
    pc.printf("Step3\r\n");
    {
        uint8_t seg_bf[6] =  {
            0b00000001     // LSB
            ,0b00000010
            ,0b10000100     // +Dot
            ,0b00001000
            ,0b00010000
            ,0b00100000     // MSB
        };

        led_7segs.zero_suppress(true);
        led_7segs.brightness(1.0f);
        int32_t count = 0;
        while(true) {
            count++;
            if (count & 0x01) {
                led_7segs.put_raw(seg_bf);
            } else {
                led_7segs.put_ascii("12.34567");
            }
            wait(1.0f);
            KEYIN_THEN_EXIT_WHILE();
        }
    }
    //--------------------------------------------------------------------------
    pc.printf("Step4\r\n");
    {
        char buf[16];

        for (uint32_t i = 0; i < sizeof(buf); i++) {
            buf[i] = ' ';
        }
        bool exit_req = false;
        while(true) {
            for (uint32_t n = ' '; n < '~'; n++) {
                for (uint32_t i = 0 ; i < sizeof(buf) - 1; i++) {
                    buf[i] = buf[i + 1];
                }
                buf[NUM_OF_DIGIT - 1] = n;
                pc.putc(n);
                led_7segs.put_strings(buf);
                led_7segs.brightness(vol);
                wait(1.0f);
                if(exit_while_loop_when_keyinput()) {
                    exit_req = true;
                    break;
                }
            }
            if (exit_req == true) {
                break;
            }
        }
        for (uint32_t i = 0; i < sizeof(buf); i++) {
            buf[i] = ' ';
        }
        led_7segs.put_strings(buf);
        pc.printf("\r\n");
    }
    //--------------------------------------------------------------------------
    pc.printf("Step5\r\n");
    {
        char buf[16];

        pc.printf("hit [Esc] to exit the function\r\n");
        for (uint32_t i = 0; i < sizeof(buf); i++) {
            buf[i] = ' ';
        }
        led_7segs.put_strings(buf);
        while(true) {
            while(pc.readable() == 0) {
                ;
            }
            char c = pc.getc();
            pc.putc(c);
            if (c == 0x1b) {    // [Esc]
                break;
            }
            for (uint32_t i = 0 ; i < sizeof(buf) - 1; i++) {
                buf[i] = buf[i + 1];
            }
            buf[NUM_OF_DIGIT - 1] = c;
            led_7segs.put_strings(buf);
        }
        for (uint32_t i = 0; i < sizeof(buf); i++) {
            buf[i] = ' ';
        }
        led_7segs.put_strings(buf);
        pc.printf("\r\n");
    }
    //--------------------------------------------------------------------------
    pc.printf("Step_END\r\n");
    {
        while(true) {
            pc.printf("Finished -> Reset then start again\r\n");
            wait(10.0f);
        }
    }
}

bool exit_while_loop_when_keyinput(void)
{
    if (pc.readable()) {
        while(pc.readable()) {
            char c = pc.getc();
        }
        return true;
    } else {
        return false;
    }
}
