/*
 * mbed Library program
 *      Check RTC function and set proper clock if we can set
 *      ONLY FOR "Nucleo Board"
 *
 *  Copyright (c) 2010-2015 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  October   24th, 2014
 *      Revised:  May       16th, 2015
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef CHECK_RTC_H
#define CHECK_RTC_H

#include "mbed.h"

#define TIMEOUT         ((uint32_t)5000)

enum {
    UNKNOWN = -1,
    NG =0,
    OK
};

/** Checking program for RTC module inside CPU
 *      Latest Nucleo board has external LSE Crystal X2 but no proper setting both HW ans SW
 *      This program intends to use RTC with X2
 *
 * @code
 * #include "mbed.h"
 * #include "CheckRTC.h"
 *
 * int main() {
 *   time_t seconds;
 *
 *   CheckRTC();
 *   printf("Time: %s", ctime(&seconds));
 * }
 * @endcode
 */

/** Check and Set RTC
  * @param none
  * @return if proper setting = OK, if not = NG and UNKNOWN-> no support this program
  */
int32_t  CheckRTC(void);
uint32_t get_RTCSEL(void);

#endif      // CHECK_RTC_H
