/*
 * Mbed Application program
 *  SD Card via USB on Mbed-os5
 *
 * Copyright (c) 2019,'20 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    December  31st, 2019
 *      Revised:    May        1st, 2020
 */

/*
 *  Tested on:
 *      Nucleo-F446RE
 *      FRDM-K64F
 *      nRF52840-DK --> does NOT work!!
 *  PC: Windows10 64bit + Tera Term
 */

#if 1

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "USBMSD.h"
#include "USBSerial.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "mon.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
#if defined(TARGET_K64F)
DigitalIn disconnect_sw(BUTTON2);
SDBlockDevice sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, 20000000);
#elif defined(TARGET_STM32F4)
DigitalIn disconnect_sw(USER_BUTTON);
SDBlockDevice sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, 20000000);
#elif defined(TARGET_MCU_NRF52840)
#warning "This program does NOT work!!"
DigitalIn disconnect_sw(BUTTON1);
SDBlockDevice sd(D11, D12, D13, D10);
#endif
Serial pc(USBTX, USBRX, 115200);
FATFileSystem *fs = NULL;
USBMSD *usb_msd = NULL;
USBSerial *usb_ser = NULL;

//  RAM ------------------------------------------------------------------------
bool stop_flag = false;
bool run_flag  = false;
bool connected_flag = false;

//  ROM / Constant data --------------------------------------------------------
const char *const opening_msg0 = "microSD Card test program";
const char *const opening_msg1 = " -> run on Mbed OS-5 multi-thread mode\r\n";

//  Function prototypes --------------------------------------------------------
static void tsk_msd(void const *args);
template <typename ... Args>
void printf_usb(const char *format, Args const & ... args);
char usb_ser_readable(void);
char usb_ser_get_c(void);
void usb_ser_put_c(char c);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
osThreadDef(tsk_msd, osPriorityNormal,2048);

int main()
{
    char buf[128];
    uint32_t step = 0;

    usb_ser = new USBSerial;
    printf_usb(
        "\r\n\r\nConnect the USB which is embedded on F446 CPU to your PC\r\n"
    );
    printf_usb("-----STEP%d------> Start\r\n", step++);
    while(true) {
        printf_usb("Please see your new strage using the Explorer\r\n");
        printf_usb("-----STEP%d------> Create USB MSD\r\n", step++);
        printf_usb(
            "If you want to disconnect the strage, please enter usr button\r\n"
        );
        ThisThread::sleep_for(100);
        // we cannot use both MSD & Serial simultaneously!!
        delete usb_ser;
        osThreadId  id = osThreadCreate(osThread(tsk_msd), NULL);
        while(true) {
            if (disconnect_sw == 0) {  break;}
            //if (stop_flag == true)  {  break;}  
        }
        stop_flag = true;
        while (run_flag == true) {
            ThisThread::sleep_for(100);
        }
        // Terminate MSD
        osThreadTerminate(id);
        pc.printf("line:%d\r\n", __LINE__);
        // Restart Serial
        usb_ser = new USBSerial;
        printf("line:%d\r\n", __LINE__);
        printf_usb("You cannot see F446 SD strage!\r\n Now open SD strage\r\n");
        printf_usb("-----STEP%d------> Disconnect USB MSD\r\n", step++);
        // Init SD CARD reader
        sd.init();
        fs = new FATFileSystem("fs");
        fs->mount(&sd);
        printf_usb("-----STEP%d------> Create microSD file system\r\n", step++);
        // Get date & time
        time_t seconds = time(NULL);
        strftime(buf, 64, "DATE %H:%M:%S,%Y/%m/%d\r\n", localtime(&seconds));
        // write data into SD
        FILE* fp = fopen("/fs/mydata.txt", "a");
        if (fp != 0) {
            usb_ser->printf("%s%s",  opening_msg0, opening_msg1);
            fprintf(fp,"%s%s", opening_msg0, opening_msg1);
            usb_ser->printf("%s", buf);     // buf = date & time
            fprintf(fp, "%s", buf);
            fflush(fp);
            fclose(fp);
        } else {
            printf_usb("ERROR\r\n");
        }
        printf_usb("-----STEP%d------> Start file monitor\r\n", step++);
        mon();
        fs->remove("fs");
        fs->unmount();
        printf_usb("-----STEP%d------> Terminate microSD\r\n", step++);
        while(true) {
            printf_usb("-----STEP%d------> Waiting restart\r\n", step);
            printf_usb("If you want to connect again, please enter 'y'\r\n>> ");
            while (usb_ser_readable() == 0) {
                ThisThread::sleep_for(100);
            }
            char c = usb_ser_get_c();
            printf_usb("%c\r\n", c);
            if (c == 'y') {
                stop_flag = false;
                break;
            }
        }
        step = 1;
    }
}

void tsk_msd(void const *args)
{
    usb_msd = new USBMSD(&sd);
    while(true) {
        if (stop_flag == false) {
            run_flag = true;
            usb_msd->process();
            //if (usb_msd->media_removed() == true) {
                //stop_flag = true;
            //}
        } else {
            usb_msd->disconnect();
            run_flag = false;
        }
    }
}

template <typename ... Args>
void printf_usb(const char *format, Args const & ... args)
{
    if (usb_ser == NULL) {
        return;
    } else {
        pc.printf(format, args ...);
        if (usb_ser->connected() == true) {
            usb_ser->printf(format, args ...);
        }
    }
}

char usb_ser_readable()
{
    if (usb_ser == NULL) {
        return 0;
    } else {
        return usb_ser->readable();
    }
}

char usb_ser_get_c()
{
    if (usb_ser == NULL) {
        return ' ';
    } else {
        return usb_ser->getc();
    }
}

void usb_ser_put_c(char c)
{
    if (usb_ser == NULL) {
        return;
    } else {
        usb_ser->putc(c);
    }
}

#endif
