//-------------------------------------------------------
//  Class for spectrum analysis using FFT (Header)
//
//  2016/07/23, Copyright (c) 2016 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "AnalysisBase.hpp"

namespace Mikami
{
    class FftAnalyzer : public AnalyzerBase
    {
    public:
        FftAnalyzer(int nData, int nFft);
        virtual ~FftAnalyzer() {}

    private:
        Array<Complex> yFft_;   // output of FFT

        virtual void Analyze(const float xn[], float yn[]);

        // disallow copy constructor and assignment operator
        FftAnalyzer(const FftAnalyzer& );
        FftAnalyzer& operator=(const FftAnalyzer& );
    };
}

#endif  // FFT_ANALYZER_HPP
